/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.upload.product;

import com.google.gson.Gson;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Recorder;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.storage.persistent.FileRecorder;
import com.qiniu.util.Auth;
import com.qiwenshare.common.util.HttpsUtils;
import com.qiwenshare.ufop.config.QiniuyunConfig;
import com.qiwenshare.ufop.constant.StorageTypeEnum;
import com.qiwenshare.ufop.constant.UploadFileStatusEnum;
import com.qiwenshare.ufop.exception.UFOPException;
import com.qiwenshare.ufop.exception.operation.UploadException;
import com.qiwenshare.ufop.operation.upload.Uploader;
import com.qiwenshare.ufop.operation.upload.domain.UploadFile;
import com.qiwenshare.ufop.operation.upload.domain.UploadFileResult;
import com.qiwenshare.ufop.operation.upload.request.QiwenMultipartFile;
import com.qiwenshare.ufop.util.QiniuyunUtils;
import com.qiwenshare.ufop.util.RedisUtil;
import com.qiwenshare.ufop.util.UFOPUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QiniuyunKodoUploader
extends Uploader {
    private static final Logger log = LoggerFactory.getLogger(QiniuyunKodoUploader.class);
    private QiniuyunConfig qiniuyunConfig;
    @Resource
    RedisUtil redisUtil;

    public QiniuyunKodoUploader() {
    }

    public QiniuyunKodoUploader(QiniuyunConfig qiniuyunConfig) {
        this.qiniuyunConfig = qiniuyunConfig;
    }

    @Override
    public void cancelUpload(UploadFile uploadFile) {
    }

    @Override
    protected void doUploadFileChunk(QiwenMultipartFile qiwenMultipartFile, UploadFile uploadFile) {
    }

    @Override
    protected UploadFileResult organizationalResults(QiwenMultipartFile qiwenMultipartFile, UploadFile uploadFile) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UploadFileResult doUploadFlow(QiwenMultipartFile qiwenMultipartFile, UploadFile uploadFile) {
        UploadFileResult uploadFileResult;
        block12: {
            uploadFileResult = new UploadFileResult();
            try {
                qiwenMultipartFile.getFileUrl(uploadFile.getIdentifier());
                String fileUrl = UFOPUtils.getUploadFileUrl(uploadFile.getIdentifier(), qiwenMultipartFile.getExtendName());
                File tempFile = UFOPUtils.getTempFile(fileUrl);
                File processFile = UFOPUtils.getProcessFile(fileUrl);
                byte[] fileData = qiwenMultipartFile.getUploadBytes();
                this.writeByteDataToFile(fileData, tempFile, uploadFile);
                boolean isComplete = this.checkUploadStatus(uploadFile, processFile);
                uploadFileResult.setFileUrl(fileUrl);
                uploadFileResult.setFileName(qiwenMultipartFile.getFileName());
                uploadFileResult.setExtendName(qiwenMultipartFile.getExtendName());
                uploadFileResult.setFileSize(uploadFile.getTotalSize());
                uploadFileResult.setStorageType(StorageTypeEnum.QINIUYUN_KODO);
                if (uploadFile.getTotalChunks() == 1) {
                    uploadFileResult.setFileSize(qiwenMultipartFile.getSize());
                }
                uploadFileResult.setIdentifier(uploadFile.getIdentifier());
                if (isComplete) {
                    this.qiniuUpload(fileUrl, tempFile, uploadFile);
                    uploadFileResult.setFileUrl(fileUrl);
                    boolean result = tempFile.delete();
                    if (!result) {
                        throw new UFOPException("\u5220\u9664temp\u6587\u4ef6\u5931\u8d25\uff1a\u76ee\u5f55\u8def\u5f84\uff1a" + tempFile.getPath());
                    }
                    if (UFOPUtils.isImageFile(uploadFileResult.getExtendName())) {
                        Auth auth = Auth.create((String)this.qiniuyunConfig.getKodo().getAccessKey(), (String)this.qiniuyunConfig.getKodo().getSecretKey());
                        String urlString = auth.privateDownloadUrl(this.qiniuyunConfig.getKodo().getDomain() + "/" + uploadFileResult.getFileUrl());
                        InputStream inputStream = HttpsUtils.doGet((String)urlString, null);
                        try {
                            BufferedImage src = ImageIO.read(inputStream);
                            uploadFileResult.setBufferedImage(src);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)inputStream);
                        }
                    }
                    uploadFileResult.setStatus(UploadFileStatusEnum.SUCCESS);
                    break block12;
                }
                uploadFileResult.setStatus(UploadFileStatusEnum.UNCOMPLATE);
            }
            catch (IOException e) {
                throw new UploadException(e);
            }
        }
        return uploadFileResult;
    }

    private void qiniuUpload(String fileUrl, File file, UploadFile uploadFile) {
        Configuration cfg = QiniuyunUtils.getCfg(this.qiniuyunConfig);
        cfg.resumableUploadAPIVersion = Configuration.ResumableUploadAPIVersion.V2;
        cfg.resumableUploadMaxConcurrentTaskCount = 2;
        Auth auth = Auth.create((String)this.qiniuyunConfig.getKodo().getAccessKey(), (String)this.qiniuyunConfig.getKodo().getSecretKey());
        String upToken = auth.uploadToken(this.qiniuyunConfig.getKodo().getBucketName());
        String localTempDir = UFOPUtils.getStaticPath() + "temp";
        try {
            FileRecorder fileRecorder = new FileRecorder(localTempDir);
            UploadManager uploadManager = new UploadManager(cfg, (Recorder)fileRecorder);
            try {
                Response response = uploadManager.put(file.getAbsoluteFile(), fileUrl, upToken);
                DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
                log.info(putRet.key);
                log.info(putRet.hash);
            }
            catch (QiniuException ex) {
                Response r = ex.response;
                System.err.println(r.toString());
                try {
                    System.err.println(r.bodyString());
                }
                catch (QiniuException qiniuException) {}
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

