/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.upload.request;

import com.qiwenshare.ufop.util.UFOPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.springframework.web.multipart.MultipartFile;

public class QiwenMultipartFile {
    MultipartFile multipartFile = null;

    private QiwenMultipartFile() {
    }

    public QiwenMultipartFile(MultipartFile multipartFile) {
        this.multipartFile = multipartFile;
    }

    public String getFileName() {
        String originalName = this.getMultipartFile().getOriginalFilename();
        if (!originalName.contains(".")) {
            return originalName;
        }
        return originalName.substring(0, originalName.lastIndexOf("."));
    }

    public String getExtendName() {
        String originalName = this.getMultipartFile().getOriginalFilename();
        return FilenameUtils.getExtension((String)originalName);
    }

    public String getFileUrl() {
        String uuid = UUID.randomUUID().toString();
        return UFOPUtils.getUploadFileUrl(uuid, this.getExtendName());
    }

    public String getFileUrl(String identify) {
        return UFOPUtils.getUploadFileUrl(identify, this.getExtendName());
    }

    public InputStream getUploadInputStream() throws IOException {
        return this.getMultipartFile().getInputStream();
    }

    public byte[] getUploadBytes() throws IOException {
        return this.getMultipartFile().getBytes();
    }

    public long getSize() {
        return this.getMultipartFile().getSize();
    }

    public MultipartFile getMultipartFile() {
        return this.multipartFile;
    }
}

