/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.util;

import com.qiwenshare.ufop.util.CharsetUtils;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.poi.hslf.extractor.QuickButCruddyTextExtractor;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xslf.extractor.XSLFExtractor;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;

public class ReadFileUtils {
    public static void main(String[] args) {
        try {
            System.out.println(ReadFileUtils.getContentByInputStream("pdf", new FileInputStream("C:\\Users\\\u9a6c\u8d85\\OneDrive\\\u4e2a\u4eba\u8d44\u6599\\\u9a6c\u8d85   \u5165\u804c\u6750\u6599\\\u517b\u8001\u53c2\u4fdd\u7f34\u8d39\u51ed\u8bc1--\u9a6c\u8d85.pdf")));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getContentByInputStream(String fileType, InputStream inputStream) throws IOException {
        if ("doc".equals(fileType) || "docx".equals(fileType)) {
            return ReadFileUtils.readWord(inputStream, fileType);
        }
        if ("xlsx".equals(fileType) || "xls".equals(fileType)) {
            return ReadFileUtils.readExcel(inputStream, fileType);
        }
        if ("txt".equals(fileType)) {
            return ReadFileUtils.readTxt(inputStream, fileType);
        }
        if ("pdf".equals(fileType)) {
            return ReadFileUtils.readPdf(inputStream);
        }
        if ("ppt".equals(fileType) || "pptx".equals(fileType)) {
            return ReadFileUtils.readPPT(inputStream, fileType);
        }
        System.out.println("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff01");
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readPdf(InputStream inputStream) {
        String content;
        block5: {
            PDDocument pdDocument = null;
            content = "";
            try {
                PDFParser pdfParser = new PDFParser((RandomAccessRead)new RandomAccessReadBuffer(inputStream));
                pdDocument = pdfParser.parse();
                PDFTextStripper pdfTextStripper = new PDFTextStripper();
                content = pdfTextStripper.getText(pdDocument);
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly(pdDocument);
            }
            IOUtils.closeQuietly((Closeable)pdDocument);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readTxt(InputStream inputStream, String extendName) throws IOException {
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            byte[] result = CharsetUtils.convertTxtCharsetToUTF8(bytes, extendName);
            String string = IOUtils.toString((byte[])result, (String)"UTF-8");
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readExcel(InputStream inputStream, String extendName) {
        String string;
        HSSFWorkbook wb;
        block13: {
            String string2;
            block12: {
                wb = null;
                try {
                    if ("xls".equalsIgnoreCase(extendName)) {
                        wb = new HSSFWorkbook(inputStream);
                    } else {
                        if (!"xlsx".equalsIgnoreCase(extendName)) {
                            System.out.println("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef!");
                            string2 = "";
                            IOUtils.closeQuietly((Closeable)wb);
                            break block12;
                        }
                        wb = new XSSFWorkbook(inputStream);
                    }
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                        Sheet sheet = wb.getSheetAt(i);
                        sb.append(sheet.getSheetName()).append("_");
                        int firstRowIndex = sheet.getFirstRowNum() + 1;
                        int lastRowIndex = sheet.getLastRowNum();
                        for (int rIndex = firstRowIndex; rIndex <= lastRowIndex; ++rIndex) {
                            Row row = sheet.getRow(rIndex);
                            if (row == null) continue;
                            int firstCellIndex = row.getFirstCellNum();
                            short lastCellIndex = row.getLastCellNum();
                            for (int cIndex = firstCellIndex; cIndex < lastCellIndex; ++cIndex) {
                                Cell cell = row.getCell(cIndex);
                                if (cell == null) continue;
                                sb.append(cell);
                            }
                        }
                    }
                    string = sb.toString();
                    IOUtils.closeQuietly((Closeable)wb);
                    break block13;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "";
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return string2;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return string;
        finally {
            IOUtils.closeQuietly(wb);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readWord(InputStream inputStream, String fileType) {
        String buffer = "";
        try {
            if ("doc".equalsIgnoreCase(fileType)) {
                WordExtractor ex = new WordExtractor(inputStream);
                buffer = ex.getText();
                ex.close();
            } else if ("docx".equalsIgnoreCase(fileType)) {
                XWPFWordExtractor extractor = new XWPFWordExtractor(OPCPackage.open((InputStream)inputStream));
                buffer = extractor.getText();
                extractor.close();
            } else {
                System.out.println("\u6b64\u6587\u4ef6\u4e0d\u662fword\u6587\u4ef6\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return buffer;
    }

    private static String readPPT(InputStream inputStream, String fileType) {
        String buffer = "";
        try {
            if ("ppt".equalsIgnoreCase(fileType)) {
                QuickButCruddyTextExtractor extractor = new QuickButCruddyTextExtractor(inputStream);
                buffer = extractor.getTextAsString();
                extractor.close();
            } else if ("pptx".equalsIgnoreCase(fileType)) {
                XSLFExtractor extractor = new XSLFExtractor(new XMLSlideShow(OPCPackage.open((InputStream)inputStream)));
                buffer = extractor.getText();
                extractor.close();
            }
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
        catch (OpenXML4JException e) {
            e.getMessage();
        }
        return buffer;
    }
}

