/*
 * Decompiled with CFR 0.152.
 */
package com.qiyuesuo.sdk.v2.request;

import com.qiyuesuo.sdk.v2.http.HttpParameter;
import com.qiyuesuo.sdk.v2.param.ParamSwitcher;
import com.qiyuesuo.sdk.v2.request.SdkRequest;
import com.qiyuesuo.sdk.v2.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public class ContractDownloadRequest
implements SdkRequest {
    private final String REQUEST_URL = "/v2/contract/download";
    private Long contractId;
    private String bizId;
    private String tenantName;
    private List<String> downloadItems;
    private Boolean needCompressForOneFile;
    private String fileNameRule;

    public ContractDownloadRequest() {
    }

    public ContractDownloadRequest(Long contractId) {
        this.contractId = contractId;
    }

    public ContractDownloadRequest(String bizId) {
        this.bizId = bizId;
    }

    public ContractDownloadRequest(String bizId, String tenantName) {
        this.bizId = bizId;
        this.tenantName = tenantName;
    }

    @Override
    public String getUrl() {
        return "/v2/contract/download";
    }

    @Override
    public HttpParameter getHttpParameter() {
        ParamSwitcher switcher = ParamSwitcher.newInstance("contractId", this.contractId).add("bizId", this.bizId).add("tenantName", this.tenantName).add("downloadItems", this.getItemString()).add("needCompressForOneFile", this.needCompressForOneFile).add("fileNameRule", this.fileNameRule);
        HttpParameter parameter = HttpParameter.httpGetParamer();
        parameter.setParams(switcher);
        return parameter;
    }

    public List<String> getDownloadItems() {
        return this.downloadItems;
    }

    public void setDownloadItems(List<String> downloadItems) {
        this.downloadItems = downloadItems;
    }

    public List<String> addDownloadItem(String item) {
        if (this.downloadItems == null) {
            this.downloadItems = new ArrayList<String>();
        }
        this.downloadItems.add(item);
        return this.downloadItems;
    }

    public String getItemString() {
        if (CollectionUtils.isEmpty(this.downloadItems)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String item : this.downloadItems) {
            builder.append(item).append(",");
        }
        builder.replace(builder.length() - 1, builder.length(), "");
        return builder.toString();
    }

    public Long getContractId() {
        return this.contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getBizId() {
        return this.bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public Boolean getNeedCompressForOneFile() {
        return this.needCompressForOneFile;
    }

    public void setNeedCompressForOneFile(Boolean needCompressForOneFile) {
        this.needCompressForOneFile = needCompressForOneFile;
    }

    public String getFileNameRule() {
        return this.fileNameRule;
    }

    public void setFileNameRule(String fileNameRule) {
        this.fileNameRule = fileNameRule;
    }
}

