/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.base.elasticsearch.utils;

import com.alibaba.fastjson.JSONObject;
import com.qqt.base.elasticsearch.EsPage;
import com.qqt.base.elasticsearch.builder.ElasticSearchQuery;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class ElasticSearchUtils {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchUtils.class);
    private static String hostName;
    private static String ports;
    private static String clusterName;
    private static String poolSize;
    private static TransportClient client;

    public static void setHostName(String host) {
        hostName = host;
    }

    public static void setPort(String port) {
        ports = port;
    }

    public static void setClusterName(String name) {
        clusterName = name;
    }

    public static void setPoolSize(String pool) {
        poolSize = pool;
    }

    public static synchronized TransportClient getClient() {
        if (client == null) {
            try {
                Settings esSetting = Settings.builder().put("cluster.name", clusterName).build();
                logger.info("hostName:{},port:{},clusterName:{},poolSize:{}", new Object[]{hostName, ports, clusterName, poolSize});
                client = new PreBuiltTransportClient(esSetting, new Class[0]).addTransportAddress(new TransportAddress(new InetSocketAddress(hostName, (int)Integer.valueOf(ports))));
            }
            catch (Exception e) {
                logger.error("elasticsearch TransportClient create error!!!", (Throwable)e);
            }
        }
        return client;
    }

    public static boolean createIndex(String index) {
        return ElasticSearchUtils.createIndex(index, null);
    }

    public static boolean createIndex(String index, XContentBuilder mapping) {
        if (!ElasticSearchUtils.isIndexExist(index)) {
            logger.info("Index is not exits!");
        }
        CreateIndexRequestBuilder createIndexRequestBuilder = ElasticSearchUtils.getClient().admin().indices().prepareCreate(index);
        if (mapping != null) {
            createIndexRequestBuilder.addMapping(index, mapping);
        }
        CreateIndexResponse indexResponse = (CreateIndexResponse)createIndexRequestBuilder.execute().actionGet();
        logger.info("\u6267\u884c\u5efa\u7acb\u6210\u529f\uff1f" + indexResponse.isAcknowledged());
        return indexResponse.isAcknowledged();
    }

    public static boolean createIndex(String index, XContentBuilder mapping, Settings settings) {
        if (!ElasticSearchUtils.isIndexExist(index)) {
            logger.info("Index is not exits!");
        }
        CreateIndexRequestBuilder createIndexRequestBuilder = ElasticSearchUtils.getClient().admin().indices().prepareCreate(index);
        if (settings != null) {
            createIndexRequestBuilder.setSettings(settings);
        }
        if (mapping != null) {
            createIndexRequestBuilder.addMapping(index, mapping);
        }
        CreateIndexResponse indexResponse = (CreateIndexResponse)createIndexRequestBuilder.execute().actionGet();
        logger.info("\u6267\u884c\u5efa\u7acb\u6210\u529f\uff1f" + indexResponse.isAcknowledged());
        return indexResponse.isAcknowledged();
    }

    public static boolean createIndex(String index, XContentBuilder mapping, String settings) {
        if (!ElasticSearchUtils.isIndexExist(index)) {
            logger.info("Index is not exits!");
        }
        CreateIndexRequestBuilder createIndexRequestBuilder = ElasticSearchUtils.getClient().admin().indices().prepareCreate(index);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{settings})) {
            createIndexRequestBuilder.setSettings(settings, XContentType.JSON);
        }
        if (mapping != null) {
            createIndexRequestBuilder.addMapping(index, mapping);
        }
        CreateIndexResponse indexResponse = (CreateIndexResponse)createIndexRequestBuilder.execute().actionGet();
        logger.info("\u6267\u884c\u5efa\u7acb\u6210\u529f\uff1f" + indexResponse.isAcknowledged());
        return indexResponse.isAcknowledged();
    }

    public static boolean addMapping(String index, XContentBuilder mapping) {
        if (!ElasticSearchUtils.isIndexExist(index)) {
            logger.info("Index is not exits!");
            return false;
        }
        PutMappingRequestBuilder putMappingRequestBuilder = ElasticSearchUtils.getClient().admin().indices().preparePutMapping(new String[]{index});
        if (mapping != null) {
            putMappingRequestBuilder.setSource(mapping);
            putMappingRequestBuilder.setType(index);
            PutMappingResponse indexResponse = (PutMappingResponse)putMappingRequestBuilder.execute().actionGet();
            logger.info("\u65b0\u589e\u5b57\u6bb5\u6210\u529f\uff1f" + indexResponse.isAcknowledged());
            return indexResponse.isAcknowledged();
        }
        return false;
    }

    public static boolean deleteIndex(String index) {
        DeleteIndexResponse dResponse;
        if (!ElasticSearchUtils.isIndexExist(index)) {
            logger.info("Index is not exits!");
        }
        if ((dResponse = (DeleteIndexResponse)ElasticSearchUtils.getClient().admin().indices().prepareDelete(new String[]{index}).execute().actionGet()).isAcknowledged()) {
            logger.info("delete index " + index + "  successfully!");
        } else {
            logger.info("Fail to delete index " + index);
        }
        return dResponse.isAcknowledged();
    }

    public static boolean isIndexExist(String index) {
        IndicesExistsResponse inExistsResponse = (IndicesExistsResponse)ElasticSearchUtils.getClient().admin().indices().exists(new IndicesExistsRequest(new String[]{index})).actionGet();
        if (inExistsResponse.isExists()) {
            logger.info("Index [" + index + "] is exist!");
        } else {
            logger.info("Index [" + index + "] is not exist!");
        }
        return inExistsResponse.isExists();
    }

    public static String addData(JSONObject jsonObject, String index, String type, String id) {
        IndexResponse response = (IndexResponse)((IndexRequestBuilder)ElasticSearchUtils.getClient().prepareIndex(index, type, id).setSource((Map)jsonObject).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        logger.info(String.format("addData response status:%s,id:%s", response.status().getStatus(), response.getId()));
        return response.getId();
    }

    public static String addData(HashMap<String, Object> maps, String index, String type, String id) {
        IndexResponse response = (IndexResponse)((IndexRequestBuilder)ElasticSearchUtils.getClient().prepareIndex(index, type, id).setSource(maps).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        logger.info(String.format("addData response status:%s,id:%s", response.status().getStatus(), response.getId()));
        return response.getId();
    }

    public static String addData(String json, String index, String type, String id) {
        IndexResponse response = (IndexResponse)((IndexRequestBuilder)ElasticSearchUtils.getClient().prepareIndex(index, type, id).setSource(new Object[]{json}).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        logger.info(String.format("addData response status:%s,id:%s", response.status().getStatus(), response.getId()));
        return response.getId();
    }

    public static String addData(JSONObject jsonObject, String index, String type) {
        return ElasticSearchUtils.addData(jsonObject, index, type, UUID.randomUUID().toString().replaceAll("-", "").toUpperCase());
    }

    public static String addData(HashMap<String, Object> maps, String index, String type) {
        return ElasticSearchUtils.addData(maps, index, type, UUID.randomUUID().toString().replaceAll("-", "").toUpperCase());
    }

    public static String addData(String json, String index, String type) {
        return ElasticSearchUtils.addData(json, index, type, UUID.randomUUID().toString().replaceAll("-", "").toUpperCase());
    }

    public static void deleteDataById(String index, String type, String id) {
        DeleteResponse response = (DeleteResponse)((DeleteRequestBuilder)ElasticSearchUtils.getClient().prepareDelete(index, type, id).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).execute().actionGet();
        logger.info(String.format("deleteDataById response status:%s,id:%s", response.status().getStatus(), response.getId()));
    }

    public static void updateDataById(JSONObject jsonObject, String index, String type, String id) {
        UpdateRequest updateRequest = new UpdateRequest();
        ((UpdateRequest)updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).index(index)).type(type).id(id).doc((Map)jsonObject);
        client.update(updateRequest);
    }

    public static void updateDataById(HashMap<String, Object> maps, String index, String type, String id) {
        UpdateRequest updateRequest = new UpdateRequest();
        ((UpdateRequest)updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).index(index)).type(type).id(id).doc(maps);
        client.update(updateRequest);
    }

    public static void updateDataById(String json, String index, String type, String id) {
        UpdateRequest updateRequest = new UpdateRequest();
        ((UpdateRequest)updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).index(index)).type(type).id(id).doc(new Object[]{json});
        client.update(updateRequest);
    }

    public static Map<String, Object> searchDataById(String index, String type, String id, String fields) {
        GetRequestBuilder getRequestBuilder = ElasticSearchUtils.getClient().prepareGet(index, type, id);
        if (StringUtils.isNotEmpty((CharSequence)fields)) {
            getRequestBuilder.setFetchSource(fields.split(","), null);
        }
        GetResponse getResponse = (GetResponse)getRequestBuilder.execute().actionGet();
        return getResponse.getSource();
    }

    public static List<Map<String, Object>> searchListData(String index, String type, long startTime, long endTime, Integer size, String matchStr) {
        return ElasticSearchUtils.searchListData(index, type, startTime, endTime, size, null, null, false, null, matchStr);
    }

    public static List<Map<String, Object>> searchListData(String index, String type, Integer size, String fields, String matchStr) {
        return ElasticSearchUtils.searchListData(index, type, 0L, 0L, size, fields, null, false, null, matchStr);
    }

    public static List<Map<String, Object>> searchListData(String index, String type, Integer size, String fields, String sortField, boolean matchPhrase, String matchStr) {
        return ElasticSearchUtils.searchListData(index, type, 0L, 0L, size, fields, sortField, matchPhrase, null, matchStr);
    }

    public static List<Map<String, Object>> searchListData(String index, String type, Integer size, String fields, String sortField, boolean matchPhrase, String highlightField, String matchStr) {
        return ElasticSearchUtils.searchListData(index, type, 0L, 0L, size, fields, sortField, matchPhrase, highlightField, matchStr);
    }

    public static List<Map<String, Object>> searchListData(String index, String type, long startTime, long endTime, Integer size, String fields, String sortField, boolean matchPhrase, String highlightField, String matchStr) {
        SearchRequestBuilder searchRequestBuilder = ElasticSearchUtils.getClient().prepareSearch(new String[]{index});
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            searchRequestBuilder.setTypes(type.split(","));
        }
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (startTime > 0L && endTime > 0L) {
            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").format("epoch_millis").from((Object)startTime).to((Object)endTime).includeLower(true).includeUpper(true));
        }
        if (StringUtils.isNotEmpty((CharSequence)matchStr)) {
            for (String s : matchStr.split(",")) {
                String[] ss = s.split("=");
                if (ss.length <= 1) continue;
                if (matchPhrase == Boolean.TRUE) {
                    boolQuery.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)s.split("=")[0], (Object)s.split("=")[1]));
                    continue;
                }
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)s.split("=")[0], (Object)s.split("=")[1]));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)highlightField)) {
            HighlightBuilder highlightBuilder = new HighlightBuilder();
            highlightBuilder.field(highlightField);
            searchRequestBuilder.highlighter(highlightBuilder);
        }
        searchRequestBuilder.setQuery((QueryBuilder)boolQuery);
        if (StringUtils.isNotEmpty((CharSequence)fields)) {
            searchRequestBuilder.setFetchSource(fields.split(","), null);
        }
        searchRequestBuilder.setFetchSource(true);
        if (StringUtils.isNotEmpty((CharSequence)sortField)) {
            searchRequestBuilder.addSort(sortField, SortOrder.DESC);
        }
        if (size != null && size > 0) {
            searchRequestBuilder.setSize(size.intValue());
        }
        logger.info(String.format("\n%s", searchRequestBuilder));
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
        long totalHits = searchResponse.getHits().getTotalHits();
        long length = searchResponse.getHits().getHits().length;
        logger.info(String.format("\u5171\u67e5\u8be2\u5230[%s]\u6761\u6570\u636e,\u5904\u7406\u6570\u636e\u6761\u6570[%s]", totalHits, length));
        if (searchResponse.status().getStatus() == 200) {
            return ElasticSearchUtils.setSearchResponse(searchResponse, highlightField);
        }
        return null;
    }

    public static EsPage searchDataPage(String index, String type, int currentPage, int pageSize, long startTime, long endTime, String fields, String sortField, boolean matchPhrase, String highlightField, String matchStr) {
        SearchRequestBuilder searchRequestBuilder = ElasticSearchUtils.getClient().prepareSearch(new String[]{index});
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            searchRequestBuilder.setTypes(type.split(","));
        }
        searchRequestBuilder.setSearchType(SearchType.QUERY_THEN_FETCH);
        if (StringUtils.isNotEmpty((CharSequence)fields)) {
            searchRequestBuilder.setFetchSource(fields.split(","), null);
        }
        if (StringUtils.isNotEmpty((CharSequence)sortField)) {
            searchRequestBuilder.addSort(sortField, SortOrder.DESC);
        }
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (startTime > 0L && endTime > 0L) {
            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").format("epoch_millis").from((Object)startTime).to((Object)endTime).includeLower(true).includeUpper(true));
        }
        if (StringUtils.isNotEmpty((CharSequence)matchStr)) {
            for (String s : matchStr.split(",")) {
                String[] ss = s.split("=");
                if (matchPhrase == Boolean.TRUE) {
                    boolQuery.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)s.split("=")[0], (Object)s.split("=")[1]));
                    continue;
                }
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)s.split("=")[0], (Object)s.split("=")[1]));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)highlightField)) {
            HighlightBuilder highlightBuilder = new HighlightBuilder();
            highlightBuilder.field(highlightField);
            searchRequestBuilder.highlighter(highlightBuilder);
        }
        searchRequestBuilder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        searchRequestBuilder.setQuery((QueryBuilder)boolQuery);
        searchRequestBuilder.setFrom((currentPage - 1) * pageSize).setSize(pageSize);
        searchRequestBuilder.setExplain(true);
        logger.info(String.format("\n%s", searchRequestBuilder));
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
        long totalHits = searchResponse.getHits().getTotalHits();
        long length = searchResponse.getHits().getHits().length;
        logger.debug(String.format("\u5171\u67e5\u8be2\u5230[%s]\u6761\u6570\u636e,\u5904\u7406\u6570\u636e\u6761\u6570[%s]", totalHits, length));
        if (searchResponse.status().getStatus() == 200) {
            List<Map<String, Object>> sourceList = ElasticSearchUtils.setSearchResponse(searchResponse, highlightField);
            return new EsPage(currentPage, pageSize, (int)totalHits, sourceList);
        }
        return null;
    }

    public static EsPage searchDataPage(String index, String type, ElasticSearchQuery query) {
        SearchRequestBuilder searchRequestBuilder = ElasticSearchUtils.getClient().prepareSearch(new String[]{index});
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            searchRequestBuilder.setTypes(type.split(","));
        }
        searchRequestBuilder.setSearchType(SearchType.QUERY_THEN_FETCH);
        if (query.getFields() != null && query.getFields().size() > 0) {
            searchRequestBuilder.setFetchSource(query.getFields().toArray(new String[query.getFields().size()]), null);
        }
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (query != null) {
            if (null != query.getFilter()) {
                for (ElasticSearchQuery.QueryBuilder queryBuilder : query.getFilter()) {
                    ElasticSearchQuery.Field field2;
                    List listOrfields = queryBuilder.getQuery().stream().filter(x -> x.getOperationType().equals((Object)ElasticSearchQuery.OperationType.Or)).collect(Collectors.toList());
                    List listAndfields = queryBuilder.getQuery().stream().filter(x -> x.getOperationType().equals((Object)ElasticSearchQuery.OperationType.And)).collect(Collectors.toList());
                    if (listAndfields.size() > 0) {
                        block25: for (ElasticSearchQuery.Field field2 : listAndfields) {
                            switch (field2.getSearchType()) {
                                case Range: {
                                    if (field2.getMin() != null && field2.getMax() != null) {
                                        boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)field2.getField()).from(field2.getMin()).to(field2.getMax()).includeLower(true).includeUpper(true));
                                        continue block25;
                                    }
                                    if (field2.getMin() != null && field2.getMax() == null) {
                                        boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)field2.getField()).from(field2.getMin()).includeLower(true));
                                        continue block25;
                                    }
                                    if (field2.getMin() != null || field2.getMax() == null) continue block25;
                                    boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)field2.getField()).to(field2.getMax()).includeUpper(true));
                                    continue block25;
                                }
                                case Like: {
                                    boolQuery.must((QueryBuilder)QueryBuilders.wildcardQuery((String)field2.getField(), (String)String.format("*%s*", field2.getValue())));
                                    continue block25;
                                }
                                case NotLike: {
                                    BoolQueryBuilder boolShoudQuery = QueryBuilders.boolQuery();
                                    boolShoudQuery.mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)field2.getField(), (String)String.format("*%s*", field2.getValue())));
                                    boolQuery.must((QueryBuilder)boolShoudQuery);
                                    continue block25;
                                }
                                case In: {
                                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)field2.getField(), (Collection)field2.getValues()));
                                    continue block25;
                                }
                                case NotIn: {
                                    BoolQueryBuilder boolShouQuery = QueryBuilders.boolQuery();
                                    boolShouQuery.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)field2.getField(), (Collection)field2.getValues()));
                                    boolQuery.must((QueryBuilder)boolShouQuery);
                                    continue block25;
                                }
                                case Exists: {
                                    boolQuery.must((QueryBuilder)QueryBuilders.existsQuery((String)field2.getField()));
                                    continue block25;
                                }
                                case NotExists: {
                                    BoolQueryBuilder boolShou3Query = QueryBuilders.boolQuery();
                                    boolShou3Query.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)field2.getField()));
                                    boolQuery.must((QueryBuilder)boolShou3Query);
                                    continue block25;
                                }
                                case Nested: {
                                    BoolQueryBuilder boolShouQuery3 = QueryBuilders.boolQuery();
                                    if (field2.getGroupField() != null && field2.getGroupField().size() > 0) {
                                        ElasticSearchUtils.getGroupFieldsByNested(field2.getGroupField(), boolShouQuery3);
                                    }
                                    boolQuery.must((QueryBuilder)QueryBuilders.nestedQuery((String)field2.getField(), (QueryBuilder)boolShouQuery3, (ScoreMode)ScoreMode.None));
                                    continue block25;
                                }
                                case Union: {
                                    BoolQueryBuilder boolShouQueryUnion = QueryBuilders.boolQuery();
                                    ElasticSearchUtils.getGroupFieldsByNested(field2.getGroupField(), boolShouQueryUnion);
                                    boolQuery.must((QueryBuilder)boolShouQueryUnion);
                                    continue block25;
                                }
                                case Script: {
                                    Script script = new Script(field2.getField().toString());
                                    boolQuery.must((QueryBuilder)QueryBuilders.scriptQuery((Script)script));
                                    continue block25;
                                }
                            }
                            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)field2.getField(), (Object)field2.getValue()));
                        }
                    }
                    if (listOrfields.size() <= 0) continue;
                    BoolQueryBuilder boolShouQuery = QueryBuilders.boolQuery();
                    field2 = listOrfields.iterator();
                    while (field2.hasNext()) {
                        ElasticSearchQuery.Field field3 = (ElasticSearchQuery.Field)field2.next();
                        switch (field3.getSearchType()) {
                            case Range: {
                                if (field3.getMin() != null && field3.getMax() != null) {
                                    boolShouQuery.should((QueryBuilder)QueryBuilders.rangeQuery((String)field3.getField()).from(field3.getMin()).to(field3.getMax()).includeLower(true).includeUpper(true));
                                    break;
                                }
                                if (field3.getMin() != null && field3.getMax() == null) {
                                    boolShouQuery.should((QueryBuilder)QueryBuilders.rangeQuery((String)field3.getField()).from(field3.getMin()).includeLower(true));
                                    break;
                                }
                                if (field3.getMin() != null || field3.getMax() == null) break;
                                boolShouQuery.should((QueryBuilder)QueryBuilders.rangeQuery((String)field3.getField()).to(field3.getMax()).includeUpper(true));
                                break;
                            }
                            case Like: {
                                boolShouQuery.should((QueryBuilder)QueryBuilders.wildcardQuery((String)field3.getField(), (String)String.format("*%s*", field3.getValue())));
                                break;
                            }
                            case NotLike: {
                                BoolQueryBuilder boolShoud1Query = QueryBuilders.boolQuery();
                                boolShoud1Query.mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)field3.getField(), (String)String.format("*%s*", field3.getValue())));
                                boolShouQuery.should((QueryBuilder)boolShoud1Query);
                                break;
                            }
                            case In: {
                                boolShouQuery.should((QueryBuilder)QueryBuilders.termsQuery((String)field3.getField(), (Collection)field3.getValues()));
                                break;
                            }
                            case NotIn: {
                                BoolQueryBuilder boolShou2Query = QueryBuilders.boolQuery();
                                boolShou2Query.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)field3.getField(), (Collection)field3.getValues()));
                                boolShouQuery.should((QueryBuilder)boolShou2Query);
                                break;
                            }
                            case Exists: {
                                boolShouQuery.should((QueryBuilder)QueryBuilders.existsQuery((String)field3.getField()));
                                break;
                            }
                            case NotExists: {
                                BoolQueryBuilder boolShou3Query = QueryBuilders.boolQuery();
                                boolShou3Query.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)field3.getField()));
                                boolShouQuery.should((QueryBuilder)boolShou3Query);
                                break;
                            }
                            case Nested: {
                                BoolQueryBuilder boolShouQuery3 = QueryBuilders.boolQuery();
                                if (field3.getGroupField() != null && field3.getGroupField().size() > 0) {
                                    ElasticSearchUtils.getGroupFieldsByNested(field3.getGroupField(), boolShouQuery3);
                                }
                                boolShouQuery.should((QueryBuilder)QueryBuilders.nestedQuery((String)field3.getField(), (QueryBuilder)boolShouQuery3, (ScoreMode)ScoreMode.None));
                                break;
                            }
                            case Union: {
                                BoolQueryBuilder boolShouQueryUnion = QueryBuilders.boolQuery();
                                ElasticSearchUtils.getGroupFieldsByUnion(field3.getGroupField(), boolShouQueryUnion);
                                boolShouQuery.should((QueryBuilder)boolShouQueryUnion);
                                break;
                            }
                            case Script: {
                                Script script = new Script(field3.getField().toString());
                                boolQuery.should((QueryBuilder)QueryBuilders.scriptQuery((Script)script));
                                break;
                            }
                            default: {
                                boolShouQuery.should((QueryBuilder)QueryBuilders.termQuery((String)field3.getField(), (Object)field3.getValue()));
                            }
                        }
                        if (field3.getGroupField() == null || field3.getGroupField().size() <= 0 || field3.getSearchType() == ElasticSearchQuery.SearchType.Nested || field3.getSearchType() == ElasticSearchQuery.SearchType.Union) continue;
                        ElasticSearchUtils.getGroupFields(field3.getGroupField(), boolShouQuery);
                    }
                    boolQuery.filter((QueryBuilder)boolShouQuery);
                }
            }
            if (query.getSort() != null && query.getSort().size() > 0) {
                for (ElasticSearchQuery.SortField sortField : query.getSort()) {
                    searchRequestBuilder.addSort(sortField.getField(), sortField.getOrder().toString().equals(ElasticSearchQuery.SortOrder.ASC.toString()) ? SortOrder.ASC : SortOrder.DESC);
                }
            }
        }
        searchRequestBuilder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        searchRequestBuilder.setQuery((QueryBuilder)boolQuery);
        searchRequestBuilder.setFrom((query.getCurrentPage() - 1) * query.getPageSize()).setSize(query.getPageSize());
        searchRequestBuilder.setExplain(false);
        logger.info(String.format("\n%s", searchRequestBuilder));
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
        long totalHits = searchResponse.getHits().getTotalHits();
        long length = searchResponse.getHits().getHits().length;
        if (searchResponse.status().getStatus() == 200) {
            List<Map<String, Object>> sourceList = ElasticSearchUtils.setSearchResponse(searchResponse);
            return new EsPage(query.getCurrentPage(), query.getPageSize(), (int)totalHits, sourceList);
        }
        return null;
    }

    private static void getGroupFields(List<ElasticSearchQuery.Field> fields, BoolQueryBuilder boolQuery) {
        BoolQueryBuilder boolShouQuery = QueryBuilders.boolQuery();
        block10: for (ElasticSearchQuery.Field field : fields) {
            switch (field.getSearchType()) {
                case Range: {
                    if (field.getMin() != null && field.getMax() != null) {
                        boolShouQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)field.getField()).from(field.getMin()).to(field.getMax()).includeLower(true).includeUpper(true));
                        continue block10;
                    }
                    if (field.getMin() != null && field.getMax() == null) {
                        boolShouQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)field.getField()).from(field.getMin()).includeLower(true));
                        continue block10;
                    }
                    if (field.getMin() != null || field.getMax() == null) continue block10;
                    boolShouQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)field.getField()).to(field.getMax()).includeUpper(true));
                    continue block10;
                }
                case Like: {
                    boolShouQuery.must((QueryBuilder)QueryBuilders.wildcardQuery((String)field.getField(), (String)String.format("*%s*", field.getValue())));
                    continue block10;
                }
                case NotLike: {
                    BoolQueryBuilder boolShoud1Query = QueryBuilders.boolQuery();
                    boolShoud1Query.mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)field.getField(), (String)String.format("*%s*", field.getValue())));
                    boolShouQuery.must((QueryBuilder)boolShoud1Query);
                    continue block10;
                }
                case In: {
                    boolShouQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)field.getField(), (Collection)field.getValues()));
                    continue block10;
                }
                case NotIn: {
                    BoolQueryBuilder boolShou2Query = QueryBuilders.boolQuery();
                    boolShou2Query.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)field.getField(), (Collection)field.getValues()));
                    boolShouQuery.must((QueryBuilder)boolShou2Query);
                    continue block10;
                }
                case Exists: {
                    boolShouQuery.must((QueryBuilder)QueryBuilders.existsQuery((String)field.getField()));
                    continue block10;
                }
                case NotExists: {
                    BoolQueryBuilder boolShou3Query = QueryBuilders.boolQuery();
                    boolShou3Query.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)field.getField()));
                    boolShouQuery.must((QueryBuilder)boolShou3Query);
                    continue block10;
                }
                case Script: {
                    Script script = new Script(field.getField().toString());
                    boolQuery.must((QueryBuilder)QueryBuilders.scriptQuery((Script)script));
                    continue block10;
                }
            }
            boolShouQuery.must((QueryBuilder)QueryBuilders.termQuery((String)field.getField(), (Object)field.getValue()));
        }
        boolQuery.should((QueryBuilder)boolShouQuery);
    }

    private static void getGroupFieldsByNested(List<ElasticSearchQuery.Field> fields, BoolQueryBuilder boolQuery) {
        block11: for (ElasticSearchQuery.Field field : fields) {
            switch (field.getSearchType()) {
                case Range: {
                    if (field.getMin() != null && field.getMax() != null) {
                        boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)field.getField()).from(field.getMin()).to(field.getMax()).includeLower(true).includeUpper(true));
                        continue block11;
                    }
                    if (field.getMin() != null && field.getMax() == null) {
                        boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)field.getField()).from(field.getMin()).includeLower(true));
                        continue block11;
                    }
                    if (field.getMin() != null || field.getMax() == null) continue block11;
                    boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)field.getField()).to(field.getMax()).includeUpper(true));
                    continue block11;
                }
                case Like: {
                    boolQuery.must((QueryBuilder)QueryBuilders.wildcardQuery((String)field.getField(), (String)String.format("*%s*", field.getValue())));
                    continue block11;
                }
                case NotLike: {
                    BoolQueryBuilder boolShoud1Query = QueryBuilders.boolQuery();
                    boolShoud1Query.mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)field.getField(), (String)String.format("*%s*", field.getValue())));
                    boolQuery.must((QueryBuilder)boolShoud1Query);
                    continue block11;
                }
                case In: {
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)field.getField(), (Collection)field.getValues()));
                    continue block11;
                }
                case NotIn: {
                    BoolQueryBuilder boolShou2Query = QueryBuilders.boolQuery();
                    boolShou2Query.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)field.getField(), (Collection)field.getValues()));
                    boolQuery.must((QueryBuilder)boolShou2Query);
                    continue block11;
                }
                case Exists: {
                    boolQuery.must((QueryBuilder)QueryBuilders.existsQuery((String)field.getField()));
                    continue block11;
                }
                case NotExists: {
                    BoolQueryBuilder boolShou3Query = QueryBuilders.boolQuery();
                    boolShou3Query.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)field.getField()));
                    boolQuery.must((QueryBuilder)boolShou3Query);
                    continue block11;
                }
                case Union: {
                    BoolQueryBuilder boolShouQueryUnion = QueryBuilders.boolQuery();
                    ElasticSearchUtils.getGroupFieldsByNested(field.getGroupField(), boolShouQueryUnion);
                    if (field.getOperationType().equals((Object)ElasticSearchQuery.OperationType.Or)) {
                        boolQuery.should((QueryBuilder)boolShouQueryUnion);
                        continue block11;
                    }
                    boolQuery.must((QueryBuilder)boolShouQueryUnion);
                    continue block11;
                }
                case Script: {
                    Script script = new Script(field.getField().toString());
                    if (field.getOperationType().equals((Object)ElasticSearchQuery.OperationType.Or)) {
                        boolQuery.should((QueryBuilder)QueryBuilders.scriptQuery((Script)script));
                        continue block11;
                    }
                    boolQuery.must((QueryBuilder)QueryBuilders.scriptQuery((Script)script));
                    continue block11;
                }
            }
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)field.getField(), (Object)field.getValue()));
        }
    }

    private static void getGroupFieldsByUnion(List<ElasticSearchQuery.Field> fields, BoolQueryBuilder boolQuery) {
        block11: for (ElasticSearchQuery.Field field : fields) {
            switch (field.getSearchType()) {
                case Range: {
                    if (field.getOperationType().equals((Object)ElasticSearchQuery.OperationType.Or)) {
                        if (field.getMin() != null && field.getMax() != null) {
                            boolQuery.should((QueryBuilder)QueryBuilders.rangeQuery((String)field.getField()).from(field.getMin()).to(field.getMax()).includeLower(true).includeUpper(true));
                            continue block11;
                        }
                        if (field.getMin() != null && field.getMax() == null) {
                            boolQuery.should((QueryBuilder)QueryBuilders.rangeQuery((String)field.getField()).from(field.getMin()).includeLower(true));
                            continue block11;
                        }
                        if (field.getMin() != null || field.getMax() == null) continue block11;
                        boolQuery.should((QueryBuilder)QueryBuilders.rangeQuery((String)field.getField()).to(field.getMax()).includeUpper(true));
                        continue block11;
                    }
                    if (field.getMin() != null && field.getMax() != null) {
                        boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)field.getField()).from(field.getMin()).to(field.getMax()).includeLower(true).includeUpper(true));
                        continue block11;
                    }
                    if (field.getMin() != null && field.getMax() == null) {
                        boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)field.getField()).from(field.getMin()).includeLower(true));
                        continue block11;
                    }
                    if (field.getMin() != null || field.getMax() == null) continue block11;
                    boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)field.getField()).to(field.getMax()).includeUpper(true));
                    continue block11;
                }
                case Like: {
                    if (field.getOperationType().equals((Object)ElasticSearchQuery.OperationType.Or)) {
                        boolQuery.should((QueryBuilder)QueryBuilders.wildcardQuery((String)field.getField(), (String)String.format("*%s*", field.getValue())));
                        continue block11;
                    }
                    boolQuery.must((QueryBuilder)QueryBuilders.wildcardQuery((String)field.getField(), (String)String.format("*%s*", field.getValue())));
                    continue block11;
                }
                case NotLike: {
                    BoolQueryBuilder boolShoud1Query = QueryBuilders.boolQuery();
                    boolShoud1Query.mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)field.getField(), (String)String.format("*%s*", field.getValue())));
                    if (field.getOperationType().equals((Object)ElasticSearchQuery.OperationType.Or)) {
                        boolQuery.should((QueryBuilder)boolShoud1Query);
                        continue block11;
                    }
                    boolQuery.must((QueryBuilder)boolShoud1Query);
                    continue block11;
                }
                case In: {
                    if (field.getOperationType().equals((Object)ElasticSearchQuery.OperationType.Or)) {
                        boolQuery.should((QueryBuilder)QueryBuilders.termsQuery((String)field.getField(), (Collection)field.getValues()));
                        continue block11;
                    }
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)field.getField(), (Collection)field.getValues()));
                    continue block11;
                }
                case NotIn: {
                    BoolQueryBuilder boolShou2Query = QueryBuilders.boolQuery();
                    boolShou2Query.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)field.getField(), (Collection)field.getValues()));
                    if (field.getOperationType().equals((Object)ElasticSearchQuery.OperationType.Or)) {
                        boolQuery.should((QueryBuilder)boolShou2Query);
                        continue block11;
                    }
                    boolQuery.must((QueryBuilder)boolShou2Query);
                    continue block11;
                }
                case Exists: {
                    if (field.getOperationType().equals((Object)ElasticSearchQuery.OperationType.Or)) {
                        boolQuery.should((QueryBuilder)QueryBuilders.existsQuery((String)field.getField()));
                        continue block11;
                    }
                    boolQuery.must((QueryBuilder)QueryBuilders.existsQuery((String)field.getField()));
                    continue block11;
                }
                case NotExists: {
                    BoolQueryBuilder boolShou3Query = QueryBuilders.boolQuery();
                    boolShou3Query.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)field.getField()));
                    if (field.getOperationType().equals((Object)ElasticSearchQuery.OperationType.Or)) {
                        boolQuery.should((QueryBuilder)boolShou3Query);
                        continue block11;
                    }
                    boolQuery.must((QueryBuilder)boolShou3Query);
                    continue block11;
                }
                case Union: {
                    BoolQueryBuilder boolShouQueryUnion = QueryBuilders.boolQuery();
                    ElasticSearchUtils.getGroupFieldsByUnion(field.getGroupField(), boolShouQueryUnion);
                    if (field.getOperationType().equals((Object)ElasticSearchQuery.OperationType.Or)) {
                        boolQuery.should((QueryBuilder)boolShouQueryUnion);
                        continue block11;
                    }
                    boolQuery.must((QueryBuilder)boolShouQueryUnion);
                    continue block11;
                }
                case Script: {
                    Script script = new Script(field.getField().toString());
                    if (field.getOperationType().equals((Object)ElasticSearchQuery.OperationType.Or)) {
                        boolQuery.should((QueryBuilder)QueryBuilders.scriptQuery((Script)script));
                        continue block11;
                    }
                    boolQuery.must((QueryBuilder)QueryBuilders.scriptQuery((Script)script));
                    continue block11;
                }
            }
            if (field.getOperationType().equals((Object)ElasticSearchQuery.OperationType.Or)) {
                boolQuery.should((QueryBuilder)QueryBuilders.termQuery((String)field.getField(), (Object)field.getValue()));
                continue;
            }
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)field.getField(), (Object)field.getValue()));
        }
    }

    public static List<Map<String, Object>> setSearchResponse(SearchResponse searchResponse, String highlightField) {
        ArrayList<Map<String, Object>> sourceList = new ArrayList<Map<String, Object>>();
        StringBuffer stringBuffer = new StringBuffer();
        for (SearchHit searchHit : searchResponse.getHits().getHits()) {
            Text[] text;
            searchHit.getSourceAsMap().put("id", searchHit.getId());
            if (StringUtils.isNotEmpty((CharSequence)highlightField) && (text = ((HighlightField)searchHit.getHighlightFields().get(highlightField)).getFragments()) != null) {
                for (Text str : text) {
                    stringBuffer.append(str.string());
                }
                searchHit.getSourceAsMap().put(highlightField, stringBuffer.toString());
            }
            sourceList.add(searchHit.getSourceAsMap());
        }
        return sourceList;
    }

    public static List<Map<String, Object>> setSearchResponse(SearchResponse searchResponse) {
        return ElasticSearchUtils.setSearchResponse(searchResponse, null);
    }
}

