/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.event;

import com.qqt.pool.common.config.ServerConfiguration;
import com.qqt.pool.common.dto.DataOperateLogDTO;
import com.qqt.pool.common.event.DataOperateLogEvent;
import com.qqt.pool.common.feign.AdminLogFeignService;
import com.qqt.pool.common.utils.LogAbstractUtil;
import io.github.jhipster.config.JHipsterProperties;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class DataOperateLogListener {
    private static final Logger log = LoggerFactory.getLogger(DataOperateLogListener.class);
    private final AdminLogFeignService logService;
    private final ServerConfiguration serverConfiguration;
    private final Environment environment;
    private final JHipsterProperties jHipsterProperties;

    @Async
    @Order
    @EventListener(value={DataOperateLogEvent.class})
    public void saveDateOperateLog(DataOperateLogEvent event) {
        Map source = (Map)event.getSource();
        DataOperateLogDTO dto = (DataOperateLogDTO)source.get("info");
        LogAbstractUtil.addOtherInfoToLog(dto, this.jHipsterProperties, this.environment, this.serverConfiguration);
        this.logService.saveDataOperateLog(dto);
    }

    public DataOperateLogListener(AdminLogFeignService logService, ServerConfiguration serverConfiguration, Environment environment, JHipsterProperties jHipsterProperties) {
        this.logService = logService;
        this.serverConfiguration = serverConfiguration;
        this.environment = environment;
        this.jHipsterProperties = jHipsterProperties;
    }
}

