/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.utils;

import com.google.common.collect.Sets;
import com.qqt.pool.tool.utils.CollectionUtil;
import com.qqt.pool.tool.utils.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class ExpressRegexUtil {
    public static final Pattern pattern = Pattern.compile("\\$\\{\\s*(.+?)\\s*\\}");

    public static Set<String> getSubStr(String str) {
        if (StringUtil.isBlank((CharSequence)str)) {
            return null;
        }
        str = StringUtils.trimAllWhitespace((String)str);
        HashSet set = Sets.newHashSet();
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            set.add(matcher.group(1));
        }
        return set;
    }

    public static String parse(Pattern p, String content, Map<String, String> data) {
        if (StringUtil.isBlank((CharSequence)content) || p == null || CollectionUtil.isEmpty(data)) {
            return "";
        }
        Matcher m = p.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String key = m.group(1);
            String value = data.get(key);
            m.appendReplacement(sb, value == null ? "" : value);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("aa", "123");
        map.put("bb", "678");
        String parse = ExpressRegexUtil.parse(pattern, "https://www.wode.com?a=${aa }&b=${ bb }", map);
        System.out.println("parse = " + parse);
    }
}

