/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.aop;

import com.qqt.pool.common.aop.ApiLog;
import com.qqt.pool.common.event.ApiLogPublisher;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

@Aspect
public class ApiLogAspect {
    private static final Logger log = LoggerFactory.getLogger(ApiLogAspect.class);
    @Value(value="${saveLog.api.enabled:false}")
    private boolean enabled;

    @Around(value="@annotation(apiLog)")
    public Object around(ProceedingJoinPoint point, ApiLog apiLog) throws Throwable {
        long beginTime = System.currentTimeMillis();
        Object result = point.proceed();
        if (this.enabled) {
            String className = point.getTarget().getClass().getName();
            String methodName = point.getSignature().getName();
            long time = System.currentTimeMillis() - beginTime;
            ApiLogPublisher.publishEvent(methodName, className, apiLog, time);
        }
        return result;
    }
}

