/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.service;

import com.qqt.pool.common.security.SecurityUtils;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class SessionService {
    @Autowired
    private RedisTemplate redisTemplate;
    private Logger logger = LoggerFactory.getLogger(SessionService.class);
    private Long userId;
    private String userCode;
    private String siteCode;
    private Long siteId;
    private Long storeId;
    private Long companyId;
    private Long currencyId;
    private Long languageId;
    private String storeCode;
    private String languageCode;
    private String companyCode;
    private String companyName;
    private Long departmentId;
    private String elsAccount;
    private Long provinceId;
    private String province;
    private String provinceName;
    private Long cityId;
    private String city;
    private String cityName;
    private Long districtId;
    private String district;
    private String districtName;
    private Long streetId;
    private String street;
    private String streetName;

    private void getSessionInfo() {
        String tokenKey = "JWT_TOKEN_DATA_" + SecurityUtils.getCurrentUserJWT();
        this.logger.debug("getSessionInfo ==>check tokenKey:{}", (Object)tokenKey);
        boolean hasJwtToken = this.redisTemplate.hasKey((Object)tokenKey);
        if (hasJwtToken) {
            this.logger.debug("checkExpired ==> begin get Jwt Token from redis.tokenKey:{}", (Object)tokenKey);
            Map sessionDataMap = this.redisTemplate.opsForHash().entries((Object)tokenKey);
            if (sessionDataMap != null) {
                if (sessionDataMap.containsKey("userId")) {
                    this.userId = (Long)sessionDataMap.get("userId");
                }
                if (sessionDataMap.containsKey("userCode")) {
                    this.userCode = (String)sessionDataMap.get("userCode");
                }
                if (sessionDataMap.containsKey("siteCode")) {
                    this.siteCode = (String)sessionDataMap.get("siteCode");
                }
                if (sessionDataMap.containsKey("companyCode")) {
                    this.companyCode = (String)sessionDataMap.get("companyCode");
                }
                if (sessionDataMap.containsKey("companyName")) {
                    this.companyName = (String)sessionDataMap.get("companyName");
                }
                if (sessionDataMap.containsKey("languageCode")) {
                    this.languageCode = (String)sessionDataMap.get("languageCode");
                }
                if (sessionDataMap.containsKey("storeCode")) {
                    this.storeCode = (String)sessionDataMap.get("storeCode");
                }
                if (sessionDataMap.containsKey("siteId")) {
                    this.siteId = (Long)sessionDataMap.get("siteId");
                }
                if (sessionDataMap.containsKey("storeId")) {
                    this.storeId = (Long)sessionDataMap.get("storeId");
                }
                if (sessionDataMap.containsKey("companyId")) {
                    this.companyId = (Long)sessionDataMap.get("companyId");
                }
                if (sessionDataMap.containsKey("currencyId")) {
                    this.currencyId = (Long)sessionDataMap.get("currencyId");
                }
                if (sessionDataMap.containsKey("languageId")) {
                    this.languageId = (Long)sessionDataMap.get("languageId");
                }
                if (sessionDataMap.containsKey("departmentId")) {
                    this.departmentId = (Long)sessionDataMap.get("departmentId");
                }
                if (sessionDataMap.containsKey("elsAccount")) {
                    this.elsAccount = (String)sessionDataMap.get("elsAccount");
                }
                if (sessionDataMap.containsKey("province")) {
                    this.province = (String)sessionDataMap.get("province");
                }
                if (sessionDataMap.containsKey("city")) {
                    this.city = (String)sessionDataMap.get("city");
                }
                if (sessionDataMap.containsKey("district")) {
                    this.district = (String)sessionDataMap.get("district");
                }
            }
        }
    }

    private <T> T getInfo(String key) {
        Optional<String> jwtOpt = SecurityUtils.getCurrentUserJWT();
        T info = null;
        if (jwtOpt.isPresent()) {
            String tokenKey = "JWT_TOKEN_DATA_" + jwtOpt.get().hashCode();
            this.logger.debug("getSessionInfo ==>check tokenKey:{}", (Object)tokenKey);
            boolean hasJwtToken = this.redisTemplate.hasKey((Object)tokenKey);
            if (hasJwtToken) {
                this.logger.debug("checkExpired ==> begin get Jwt Token from redis.tokenKey:{}", (Object)tokenKey);
                Map sessionDataMap = this.redisTemplate.opsForHash().entries((Object)tokenKey);
                if (sessionDataMap != null && sessionDataMap.containsKey(key)) {
                    info = (T)sessionDataMap.get(key);
                }
            }
        }
        if (info == null) {
            // empty if block
        }
        return info;
    }

    private void setInfo(String key, Object value) {
        Optional<String> jwtOpt = SecurityUtils.getCurrentUserJWT();
        if (jwtOpt.isPresent()) {
            String tokenKey = "JWT_TOKEN_DATA_" + jwtOpt.get().hashCode();
            this.logger.debug("getSessionInfo ==>check tokenKey:{}", (Object)tokenKey);
            boolean hasJwtToken = this.redisTemplate.hasKey((Object)tokenKey);
            if (hasJwtToken) {
                this.logger.debug("checkExpired ==> begin get Jwt Token from redis.tokenKey:{}", (Object)tokenKey);
                Map sessionDataMap = this.redisTemplate.opsForHash().entries((Object)tokenKey);
                sessionDataMap.put(key, value);
                this.redisTemplate.opsForHash().putAll((Object)tokenKey, sessionDataMap);
            }
        }
    }

    public Long getCurrentUserId() {
        return (Long)this.getInfo("userId");
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getCurrentUserCode() {
        return (String)this.getInfo("userCode");
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getCurrentSiteCode() {
        return (String)this.getInfo("siteCode");
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public String getCurrentStoreCode() {
        return (String)this.getInfo("storeCode");
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public String getCurrentLanguageCode() {
        return (String)this.getInfo("languageCode");
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getCurrentCompanyCode() {
        return (String)this.getInfo("companyCode");
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public String getCurrentCompanyName() {
        return (String)this.getInfo("companyName");
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Long getSiteId() {
        return (Long)this.getInfo("siteId");
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    public Long getStoreId() {
        return (Long)this.getInfo("storeId");
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public Long getCompanyId() {
        return (Long)this.getInfo("companyId");
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public Long getCurrencyId() {
        return (Long)this.getInfo("currencyId");
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public Long getLanguageId() {
        return (Long)this.getInfo("languageId");
    }

    public void setLanguageId(Long languageId) {
        this.languageId = languageId;
    }

    public Long getDepartmentId() {
        return (Long)this.getInfo("departmentId");
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public boolean isPlatform() {
        return (Boolean)this.getInfo("isPlatform");
    }

    public String getElsAccount() {
        return this.elsAccount;
    }

    public void setElsAccount(String elsAccount) {
        this.elsAccount = elsAccount;
    }

    public String getProvince() {
        return (String)this.getInfo("province");
    }

    public void setProvince(String province) {
        this.province = province;
        this.setInfo("province", province);
    }

    public String getCity() {
        return (String)this.getInfo("city");
    }

    public void setCity(String city) {
        this.city = city;
        this.setInfo("city", city);
    }

    public String getDistrict() {
        return (String)this.getInfo("district");
    }

    public void setDistrict(String district) {
        this.district = district;
        this.setInfo("district", district);
    }

    public String getProvinceName() {
        return (String)this.getInfo("provinceName");
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
        this.setInfo("provinceName", provinceName);
    }

    public String getCityName() {
        return (String)this.getInfo("cityName");
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
        this.setInfo("cityName", cityName);
    }

    public String getDistrictName() {
        return (String)this.getInfo("districtName");
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
        this.setInfo("districtName", districtName);
    }

    public String getStreet() {
        return (String)this.getInfo("street");
    }

    public void setStreet(String street) {
        this.street = street;
        this.setInfo("street", street);
    }

    public String getStreetName() {
        return (String)this.getInfo("streetName");
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
        this.setInfo("streetName", streetName);
    }

    public Long getProvinceId() {
        return (Long)this.getInfo("provinceId");
    }

    public void setProvinceId(Long provinceId) {
        this.provinceId = provinceId;
        this.setInfo("provinceId", provinceId);
    }

    public Long getCityId() {
        return (Long)this.getInfo("cityId");
    }

    public void setCityId(Long cityId) {
        this.cityId = cityId;
        this.setInfo("cityId", cityId);
    }

    public Long getDistrictId() {
        return (Long)this.getInfo("districtId");
    }

    public void setDistrictId(Long districtId) {
        this.districtId = districtId;
        this.setInfo("districtId", districtId);
    }

    public Long getStreetId() {
        return (Long)this.getInfo("streetId");
    }

    public void setStreetId(Long streetId) {
        this.streetId = streetId;
        this.setInfo("streetId", streetId);
    }
}

