/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.feign;

import com.qqt.pool.common.client.WorkflowFeignClientInterceptor;
import com.qqt.pool.common.dto.OrderDO;
import com.qqt.pool.common.dto.PurchaseRequestDO;
import com.qqt.pool.common.dto.ResultDTO;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(name="order", configuration={WorkflowFeignClientInterceptor.class})
@Component
public interface WorkFlowOrderFeignService {
    @RequestMapping(value={"/api/orders/workflow/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<OrderDO> getOrderData(@PathVariable Long var1);

    @RequestMapping(value={"/api/order/workflow/submit/{orderId}/{user}"}, method={RequestMethod.GET})
    public ResponseEntity<ResultDTO<OrderDO>> submitOrderInWorkFlow(@PathVariable Long var1, @PathVariable String var2);

    @RequestMapping(value={"/api/order/workflow/approve/{orderId}/{user}"}, method={RequestMethod.GET})
    public ResponseEntity<ResultDTO<OrderDO>> approveOrderInWorkFlow(@PathVariable Long var1, @PathVariable String var2);

    @RequestMapping(value={"/api/order/workflow/reject/{orderId}/{user}"}, method={RequestMethod.GET})
    public ResponseEntity<ResultDTO<OrderDO>> rejectOrderInWorkFlow(@PathVariable Long var1, @PathVariable String var2);

    @RequestMapping(value={"/api/purchase/workflow/createRequest/{user}"}, method={RequestMethod.POST})
    public ResponseEntity<String> createRequestInWorkFlow(@RequestBody Long[] var1, @PathVariable String var2);

    @RequestMapping(value={"/api/order-entries/workflow/{orderId}"}, method={RequestMethod.GET})
    public ResponseEntity<List<Long>> getOrderEntryInWorkFlow(@PathVariable Long var1);

    @RequestMapping(value={"/api/workflow/purchase-requests/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<PurchaseRequestDO> getPurchaseRequest(@PathVariable Long var1);

    @RequestMapping(value={"/api/purchase/workflow/submitPr/{businessId}"}, method={RequestMethod.GET})
    public ResponseEntity<ResultDTO<PurchaseRequestDO>> submitPurchaseInWorkFlow(@PathVariable Long var1);

    @RequestMapping(value={"/api/purchase/workflow/checkBudget/{businessId}"}, method={RequestMethod.GET})
    public ResponseEntity<ResultDTO<PurchaseRequestDO>> checkBudgetInWorkFlow(@PathVariable Long var1);

    @RequestMapping(value={"/api/purchase/workflow/approvePr/{businessId}"}, method={RequestMethod.GET})
    public ResponseEntity<ResultDTO<PurchaseRequestDO>> approvePrInWorkFlow(@PathVariable Long var1);

    @RequestMapping(value={"/api/purchase/workflow/rejectPo/{businessId}"}, method={RequestMethod.GET})
    public ResponseEntity<ResultDTO<PurchaseRequestDO>> rejectPrInWorkFlow(@PathVariable Long var1);

    @RequestMapping(value={"/api/workflow/purchase-orders/{businessId}"}, method={RequestMethod.GET})
    public ResponseEntity<Map> getPurchaseOrderInWorkFlow(@PathVariable Long var1);

    @RequestMapping(value={"/api/purchase/workflow/submitPo/{businessId}"}, method={RequestMethod.GET})
    public ResponseEntity<ResultDTO<Void>> submitPoInWorkFlow(@PathVariable Long var1);

    @RequestMapping(value={"/api/purchase/workflow/approvePo/{businessId}"}, method={RequestMethod.GET})
    public ResponseEntity<ResultDTO<Void>> approvePoInWorkFlow(@PathVariable Long var1);

    @RequestMapping(value={"/api/purchase/workflow/rejectPo/{businessId}"}, method={RequestMethod.GET})
    public ResponseEntity<ResultDTO<Void>> rejectPoInWorkFlow(@PathVariable Long var1);

    @RequestMapping(value={"/api/purchase-orders/workflow/{businessId}"}, method={RequestMethod.GET})
    public ResponseEntity<Map> getPurchaseOrderByPrIdInWorkFlow(@PathVariable Long var1);
}

