/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.utils;

import com.qqt.pool.common.config.ServerConfiguration;
import com.qqt.pool.common.dto.LogAbstract;
import com.qqt.pool.tool.utils.DateUtil;
import com.qqt.pool.tool.utils.ObjectUtil;
import com.qqt.pool.tool.utils.UrlUtil;
import com.qqt.pool.tool.utils.WebUtil;
import io.github.jhipster.config.JHipsterProperties;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.env.Environment;

public class LogAbstractUtil {
    public static void addRequestInfoToLog(HttpServletRequest request, LogAbstract logAbstract) {
        if (ObjectUtil.isNotEmpty((Object)request)) {
            logAbstract.setRemoteIp(WebUtil.getIP((HttpServletRequest)request));
            logAbstract.setUserAgent(request.getHeader("user-agent"));
            logAbstract.setRequestUri(UrlUtil.getPath((String)request.getRequestURI()));
            logAbstract.setMethod(request.getMethod());
            logAbstract.setToken(request.getHeader("Authorization"));
            logAbstract.setParams(WebUtil.getRequestContent((HttpServletRequest)request));
        }
    }

    public static void addOtherInfoToLog(LogAbstract logAbstract, JHipsterProperties jhipsterProperties, Environment env, ServerConfiguration serverConfiguration) {
        logAbstract.setServiceId(jhipsterProperties.getClientApp().getName());
        logAbstract.setServerHost(serverConfiguration.getHostName());
        logAbstract.setServerIp(serverConfiguration.getIpWithPort());
        String[] profiles = env.getActiveProfiles();
        if (null == profiles || profiles.length == 0) {
            profiles = env.getDefaultProfiles();
        }
        String activeProfile = "";
        if (null != profiles && profiles.length >= 0) {
            activeProfile = profiles[0];
        }
        logAbstract.setEnv(activeProfile);
        logAbstract.setCreateTime(DateUtil.now());
        if (logAbstract.getParams() == null) {
            logAbstract.setParams("");
        }
    }
}

