/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.aop;

import com.qqt.pool.common.dto.LogApiDTO;
import com.qqt.pool.common.event.ApiLogPublisher;
import com.qqt.pool.common.service.SessionService;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Aspect
public class ApiLogAspect {
    private static final Logger log = LoggerFactory.getLogger(ApiLogAspect.class);
    @Value(value="${saveLog.api.enabled:false}")
    private boolean enabled;
    @Autowired
    private SessionService sessionService;

    @Pointcut(value="within(@org.springframework.web.bind.annotation.RestController *)")
    public void apiPointcut() {
    }

    @Around(value="apiPointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        Object result = point.proceed();
        if (this.enabled) {
            String className = point.getTarget().getClass().getName();
            long time = System.currentTimeMillis() - beginTime;
            MethodSignature signature = (MethodSignature)point.getSignature();
            Method method = signature.getMethod();
            String methodName = method.getName();
            String title = this.getApiDescription(method);
            Long userId = this.sessionService.getCurrentUserId();
            Long companyId = this.sessionService.getCompanyId();
            String siteCode = this.sessionService.getCurrentSiteCode();
            String login = this.sessionService.getCurrentUserCode();
            String elsAccount = this.sessionService.getElsAccount();
            String companyName = this.sessionService.getCurrentCompanyName();
            LogApiDTO logApiDTO = new LogApiDTO();
            logApiDTO.setTime(time);
            logApiDTO.setLogin(login);
            logApiDTO.setUserId(userId);
            logApiDTO.setSiteCode(siteCode);
            logApiDTO.setElsAccount(elsAccount);
            logApiDTO.setCompanyName(companyName);
            logApiDTO.setCompanyId(companyId);
            logApiDTO.setTitle(title);
            logApiDTO.setMethodClass(className);
            logApiDTO.setMethodName(methodName);
            logApiDTO.setType("1");
            ApiLogPublisher.publishEvent(logApiDTO);
        }
        return result;
    }

    private String getApiDescription(Method method) {
        String title = method.getName();
        if (method.isAnnotationPresent(GetMapping.class)) {
            title = method.getDeclaredAnnotation(GetMapping.class).name();
        } else if (method.isAnnotationPresent(PostMapping.class)) {
            title = method.getDeclaredAnnotation(PostMapping.class).name();
        } else if (method.isAnnotationPresent(PutMapping.class)) {
            title = method.getDeclaredAnnotation(PutMapping.class).name();
        } else if (method.isAnnotationPresent(DeleteMapping.class)) {
            title = method.getDeclaredAnnotation(DeleteMapping.class).name();
        } else if (method.isAnnotationPresent(RequestMapping.class)) {
            title = method.getDeclaredAnnotation(RequestMapping.class).name();
        }
        return title;
    }
}

