/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.cache.Cache;
import javax.cache.configuration.Configuration;
import org.redisson.jcache.JCacheManager;
import org.redisson.jcache.configuration.RedissonConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class JCacheManagerUtils {
    @Autowired
    private JCacheManager jCacheManager;
    @Autowired
    private RedissonConfiguration redissonConfiguration;

    public Cache<Object, Object> getCacheByCacheNameOrType(String cacheName, Class type) {
        Cache cacheData = null;
        if (this.jCacheManager != null && this.redissonConfiguration != null) {
            if (StringUtils.isEmpty((Object)cacheName) && type == null) {
                return null;
            }
            cacheData = StringUtils.isEmpty((Object)cacheName) ? this.jCacheManager.getCache(type.getName()) : this.jCacheManager.getCache(cacheName);
            if (cacheData == null) {
                cacheData = StringUtils.isEmpty((Object)cacheName) ? this.jCacheManager.createCache(type.getName(), (Configuration)this.redissonConfiguration) : this.jCacheManager.createCache(cacheName, (Configuration)this.redissonConfiguration);
            }
            return cacheData;
        }
        return null;
    }

    public Cache<Object, Object> getCacheByKey(String key) {
        Cache cacheData = null;
        if (this.jCacheManager != null && this.redissonConfiguration != null) {
            if (StringUtils.isEmpty((Object)key)) {
                return null;
            }
            cacheData = this.jCacheManager.getCache(key);
            if (cacheData == null) {
                cacheData = this.jCacheManager.createCache(key, (Configuration)this.redissonConfiguration);
            }
            return cacheData;
        }
        return null;
    }

    public <T> boolean invalidCache(T t) throws InvocationTargetException, IllegalAccessException, IntrospectionException {
        PropertyDescriptor[] propertyDescriptors;
        Cache cache = this.jCacheManager.getCache(t.getClass().getName());
        if (null == cache) {
            return true;
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(t.getClass());
        for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            if (!property.getName().equalsIgnoreCase("Id")) continue;
            Method getter = property.getReadMethod();
            Object key = getter != null ? getter.invoke(t, new Object[0]) : null;
            return cache.remove(key);
        }
        return false;
    }
}

