/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.event.listener.order;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.common.config.KafkaMessage;
import com.qqt.pool.common.dto.CommonMessageDO;
import com.qqt.pool.common.enumeration.ThirdOrderEventEnum;
import com.qqt.pool.common.event.order.CommonOrderCreatedEvent;
import com.qqt.pool.common.utils.DateUtil;
import com.qqt.pool.common.utils.KafkaProduceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@Order(value=-100)
public class CommonOrderCreatedEventListener
implements ApplicationListener<CommonOrderCreatedEvent> {
    private final Logger log = LoggerFactory.getLogger(CommonOrderCreatedEventListener.class);
    @Autowired
    private KafkaProduceUtil kafkaProduceUtil;
    @Value(value="${common.message}")
    private String commonMsg;

    public void onApplicationEvent(CommonOrderCreatedEvent event) {
        this.log.info("\u5f02\u6b65\u76d1\u542c\u4e8b\u4ef6 start");
        CommonMessageDO message = new CommonMessageDO();
        message.setContent(JSON.toJSONString((Object)event.getOrder()));
        message.setCompanyId(event.getCompanyId());
        message.setType(ThirdOrderEventEnum.ORDER_SUBMIT.getCode());
        message.setTime(DateUtil.nowOfStringByDateTime());
        message.setThirdCode(event.getThirdCode());
        message.setMsgType("ORDER");
        message.setToken(event.getToken());
        this.log.info("kafka send message : {}---", (Object)JSON.toJSONString((Object)message));
        KafkaMessage kafkaMessage = new KafkaMessage();
        kafkaMessage.setChannel(this.commonMsg);
        kafkaMessage.setMessage(JSON.parseObject((String)JSON.toJSONString((Object)message)));
        this.kafkaProduceUtil.sendMessage(kafkaMessage);
    }
}

