/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.utils;

import com.qqt.pool.common.utils.FastStringWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;

public class Exceptions {
    public static RuntimeException unchecked(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException(((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        return (RuntimeException)Exceptions.runtime(e);
    }

    private static <T extends Throwable> T runtime(Throwable throwable) throws T {
        throw throwable;
    }

    public static Throwable unwrap(Throwable wrapped) {
        Throwable unwrapped = wrapped;
        while (true) {
            if (unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            if (!(unwrapped instanceof UndeclaredThrowableException)) break;
            unwrapped = ((UndeclaredThrowableException)unwrapped).getUndeclaredThrowable();
        }
        return unwrapped;
    }

    public static String getStackTraceAsString(Throwable ex) {
        FastStringWriter stringWriter = new FastStringWriter();
        ex.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

