/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.dto;

import com.google.common.collect.Lists;
import com.qqt.pool.common.dto.PlatformDetail;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.util.CollectionUtils;

public class PlatformResultDTO<T>
implements Serializable {
    private static final long serialVersionUID = -3917209432555044660L;
    private List<Map<String, Object>> successList;
    private List<Map<String, Object>> errorList;
    private Page<T> page;

    public static PlatformResultDTO fastForOne(PlatformDetail successDetail, PlatformDetail errorDetail) {
        ArrayList<Map<String, Object>> list;
        PlatformResultDTO resultDTO = new PlatformResultDTO();
        if (successDetail != null && successDetail.getId() != null) {
            list = new ArrayList<Map<String, Object>>(2);
            list.add(PlatformResultDTO.fillMap(successDetail));
            resultDTO.setSuccessList(list);
        }
        if (errorDetail != null && errorDetail.getId() != null) {
            list = new ArrayList(2);
            list.add(PlatformResultDTO.fillMap(errorDetail));
            resultDTO.setSuccessList(list);
        }
        return resultDTO;
    }

    public static PlatformResultDTO fastForList(List<PlatformDetail> successDetails, List<PlatformDetail> errorDetails) {
        ArrayList list;
        PlatformResultDTO resultDTO = new PlatformResultDTO();
        if (!CollectionUtils.isEmpty(successDetails)) {
            list = Lists.newArrayList();
            for (PlatformDetail detail : successDetails) {
                list.add(PlatformResultDTO.fillMap(detail));
            }
            resultDTO.setSuccessList(list);
        }
        if (!CollectionUtils.isEmpty(errorDetails)) {
            list = Lists.newArrayList();
            for (PlatformDetail detail : errorDetails) {
                list.add(PlatformResultDTO.fillMap(detail));
            }
            resultDTO.setErrorList(list);
        }
        return resultDTO;
    }

    public static <T> PlatformResultDTO putPage(Page<T> page) {
        PlatformResultDTO<T> resultDTO = new PlatformResultDTO<T>();
        resultDTO.setPage(page);
        return resultDTO;
    }

    private static Map<String, Object> fillMap(PlatformDetail detail) {
        HashMap<String, Object> successMap = new HashMap<String, Object>(4);
        successMap.put("id", detail.getId());
        successMap.put("code", detail.getCode());
        successMap.put("name", detail.getName());
        successMap.put("message", detail.getMessage());
        return successMap;
    }

    public Page<T> getPage() {
        return this.page;
    }

    public void setPage(Page<T> page) {
        this.page = page;
    }

    public List<Map<String, Object>> getSuccessList() {
        return this.successList;
    }

    public void setSuccessList(List<Map<String, Object>> successList) {
        this.successList = successList;
    }

    public List<Map<String, Object>> getErrorList() {
        return this.errorList;
    }

    public void setErrorList(List<Map<String, Object>> errorList) {
        this.errorList = errorList;
    }
}

