/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.event;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.common.config.KafkaMessage;
import com.qqt.pool.common.config.ServerConfiguration;
import com.qqt.pool.common.dto.LogApiDTO;
import com.qqt.pool.common.event.ApiLogEvent;
import com.qqt.pool.common.utils.KafkaProduceUtil;
import com.qqt.pool.common.utils.LogAbstractUtil;
import io.github.jhipster.config.JHipsterProperties;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ApiLogListener {
    private static final Logger log = LoggerFactory.getLogger(ApiLogListener.class);
    @Autowired
    private KafkaProduceUtil kafkaProduceUtil;
    @Autowired
    private ServerConfiguration serverConfiguration;
    @Autowired
    private JHipsterProperties jHipsterProperties;
    @Value(value="${spring.profiles.active}")
    private String env;

    @Async
    @Order
    @EventListener(value={ApiLogEvent.class})
    public void saveApiLog(ApiLogEvent event) {
        Map source = (Map)event.getSource();
        LogApiDTO logApi = (LogApiDTO)source.get("info");
        logApi.setEnv(this.env);
        LogAbstractUtil.addOtherInfoToLog(logApi, this.jHipsterProperties, this.serverConfiguration);
        KafkaMessage kafkaMessage = new KafkaMessage();
        kafkaMessage.setChannel("pool_api_log_" + this.env);
        kafkaMessage.setMessage(JSON.parseObject((String)JSON.toJSONString((Object)logApi)));
        this.kafkaProduceUtil.sendMessage(kafkaMessage);
    }
}

