/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.event.listener.order;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.common.config.KafkaMessage;
import com.qqt.pool.common.dto.CommonMessageDO;
import com.qqt.pool.common.dto.platform.UpdateMessageDO;
import com.qqt.pool.common.enumeration.ThirdOrderEventEnum;
import com.qqt.pool.common.event.order.CommonReturnOrderChangeEvent;
import com.qqt.pool.common.utils.DateUtil;
import com.qqt.pool.common.utils.KafkaProduceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@Order(value=-100)
public class CommonReturnOrderChangeEventListener
implements ApplicationListener<CommonReturnOrderChangeEvent> {
    @Autowired
    private KafkaProduceUtil kafkaProduceUtil;
    @Value(value="${common.message}")
    private String commonMsg;

    public void onApplicationEvent(CommonReturnOrderChangeEvent event) {
        UpdateMessageDO ud = new UpdateMessageDO();
        ud.setCode(event.getThirdCode());
        ud.setDataId(event.getReturnOrderId());
        ud.setStatus(event.getStatus());
        ud.setCustomerCompanyId(event.getCustomerCompanyId());
        CommonMessageDO message = new CommonMessageDO();
        message.setMsgType("ORDER");
        message.setType(ThirdOrderEventEnum.RETURN_ORDER_CHANGE.getCode());
        message.setThirdCode(event.getThirdCode());
        message.setTime(DateUtil.nowOfStringByDateTime());
        message.setToken(event.getToken());
        message.setContent(JSON.toJSONString((Object)ud));
        message.setCompanyId(event.getCompanyId());
        KafkaMessage kafkaMessage = new KafkaMessage();
        kafkaMessage.setChannel(this.commonMsg);
        kafkaMessage.setMessage(JSON.parseObject((String)JSON.toJSONString((Object)message)));
        this.kafkaProduceUtil.sendMessage(kafkaMessage);
    }
}

