/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.facade.provide;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.qqt.pool.common.dto.ResultDTO;
import com.qqt.pool.common.dto.UserDTO;
import com.qqt.pool.common.dto.message.BillRelationDTO;
import com.qqt.pool.common.dto.message.UserTargetDTO;
import com.qqt.pool.common.facade.MessageRecevierProvide;
import com.qqt.pool.common.feign.AdminFeignService;
import com.qqt.pool.common.utils.JCacheManagerUtils;
import com.qqt.pool.common.utils.ResultUtil;
import java.util.List;
import java.util.Set;
import javax.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractMessageRecevierProvideImpl
implements MessageRecevierProvide {
    private final Logger log = LoggerFactory.getLogger(AbstractMessageRecevierProvideImpl.class);
    @Autowired
    private AdminFeignService adminFeignService;
    @Autowired
    JCacheManagerUtils jCacheManagerUtils;

    @Override
    public ResultDTO<Set<UserTargetDTO>> getRecevierList(List<BillRelationDTO> billRelationDTOS) {
        this.log.debug("getRecevierList params:{}", billRelationDTOS);
        if (CollectionUtils.isEmpty(billRelationDTOS)) {
            return ResultUtil.fail("getRecevierList params can not empty");
        }
        ResultDTO valid = this.validBillRelationDTO(billRelationDTOS);
        if (!valid.isSuccess()) {
            return valid;
        }
        return this.process(billRelationDTOS);
    }

    public abstract ResultDTO<Set<UserTargetDTO>> process(List<BillRelationDTO> var1);

    private ResultDTO validBillRelationDTO(List<BillRelationDTO> billRelationDTOS) {
        for (BillRelationDTO relation : billRelationDTOS) {
            if (relation.getBillId() == null) {
                return ResultUtil.fail("getRecevierList params BillId is empty");
            }
            if (!StringUtils.isEmpty((Object)relation.getReceIdField()) && !StringUtils.isEmpty((Object)relation.getReceType()) && !StringUtils.isEmpty((Object)relation.getTableName())) continue;
            return ResultUtil.fail("getRecevierList params some is empty");
        }
        return ResultUtil.success();
    }

    public String getCurrentUserName(Long userId) {
        block9: {
            if (userId == null) {
                return null;
            }
            Cache<Object, Object> userDataCache = this.jCacheManagerUtils.getCacheByKey("com.qqt.pool.admin.domain.User");
            ObjectMapper objectMapper = new ObjectMapper();
            UserDTO userDTO = null;
            if (userDataCache != null) {
                userDTO = (UserDTO)objectMapper.convertValue(userDataCache.get((Object)userId), UserDTO.class);
            }
            if (userDTO != null) {
                if (StringUtils.isEmpty((Object)userDTO.getNameCn())) {
                    return userId + "";
                }
                return userDTO.getNameCn();
            }
            try {
                ResponseEntity<ResultDTO<UserDTO>> userEntity = this.adminFeignService.getUserById(userId);
                if (userEntity != null && userEntity.getBody() != null && ((ResultDTO)userEntity.getBody()).getData() != null) {
                    ResultDTO resultDTO = (ResultDTO)userEntity.getBody();
                    if (resultDTO.getData() != null) {
                        userDTO = (UserDTO)resultDTO.getData();
                        if (StringUtils.isEmpty((Object)userDTO.getNameCn())) {
                            return userId + "";
                        }
                        return userDTO.getNameCn();
                    }
                    break block9;
                }
                return userId + "";
            }
            catch (Exception e) {
                this.log.error("getUserDetail userId error,userId:{},error:{}", (Object)userId, (Object)e);
                return userId + "";
            }
        }
        return null;
    }
}

