/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.excel.validate;

import com.qqt.pool.common.dto.UserDTO;
import com.qqt.pool.common.excel.validate.ValidateErrorMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidateUserData {
    private static String LOGIN_IS_HAVE = "\u5f53\u524d\u7528\u6237\u540d\u5df2\u5b58\u5728";
    private static String EMAIL_IS_HAVE = "\u5f53\u524d\u90ae\u7bb1\u5df2\u5b58\u5728";
    private List<UserDTO> userDTOList;
    private List<Map> all;

    public ValidateUserData(List<UserDTO> userDTOList, List<Map> all) {
        this.userDTOList = userDTOList;
        this.all = all;
    }

    public Map<String, Object> validate() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<ValidateErrorMessage> errorMessages = new ArrayList<ValidateErrorMessage>();
        ArrayList<UserDTO> resultUser = new ArrayList<UserDTO>();
        HashMap loginMap = new HashMap();
        HashMap mailMap = new HashMap();
        for (Map user : this.all) {
            loginMap.put(((String)user.get("login")).toLowerCase(), null);
            mailMap.put((String)user.get("email"), null);
        }
        for (UserDTO userDTO : this.userDTOList) {
            String loginName = userDTO.getLogin().toLowerCase();
            String mail = userDTO.getEmail();
            boolean isHaveUserName = false;
            if (loginMap.containsKey(loginName)) {
                ValidateErrorMessage errorMessage = new ValidateErrorMessage(userDTO.getLogin(), LOGIN_IS_HAVE);
                errorMessages.add(errorMessage);
                isHaveUserName = true;
            }
            boolean isHaveEmail = false;
            if (mailMap.containsKey(mail)) {
                ValidateErrorMessage errorMessage = new ValidateErrorMessage(mail, EMAIL_IS_HAVE);
                errorMessages.add(errorMessage);
                isHaveEmail = true;
            }
            if (isHaveUserName || isHaveEmail) continue;
            resultUser.add(userDTO);
        }
        result.put("validateErrorMessage", errorMessages);
        result.put("userList", resultUser);
        return result;
    }
}

