/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.facade.provide;

import com.google.common.collect.Sets;
import com.qqt.pool.common.dto.ResultDTO;
import com.qqt.pool.common.dto.message.BillRelationDTO;
import com.qqt.pool.common.dto.message.UserTargetDTO;
import com.qqt.pool.common.facade.provide.AbstractMessageRecevierProvideImpl;
import com.qqt.pool.common.facade.provide.QueryTableRepository;
import com.qqt.pool.common.utils.ResultUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultMessageRecevierProvideImpl
extends AbstractMessageRecevierProvideImpl {
    private final Logger log = LoggerFactory.getLogger(DefaultMessageRecevierProvideImpl.class);
    @Autowired
    private QueryTableRepository queryTableRepository;

    @Override
    public ResultDTO<Set<UserTargetDTO>> process(List<BillRelationDTO> billRelationDTOS) {
        HashSet targetDTOS = Sets.newHashSet();
        try {
            for (BillRelationDTO relation : billRelationDTOS) {
                Long receId = this.queryTableRepository.queryTableById(relation.getBillId(), relation.getTableName(), relation.getReceIdField());
                if (receId == null) {
                    return ResultUtil.fail("query data is null with billId");
                }
                UserTargetDTO target = new UserTargetDTO();
                target.setTargetId(receId);
                target.setTargetType(relation.getReceType());
                target.setTargetName(this.getCurrentUserName(receId));
                targetDTOS.add(target);
            }
        }
        catch (Exception e) {
            this.log.error("\u8868\u6216\u5b57\u6bb5\u4e0d\u5b58\u5728\uff1a{}", (Throwable)e);
            return ResultUtil.fail("tableName or Field not exists");
        }
        return ResultUtil.success(targetDTOS);
    }
}

