/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.service.client;

import com.qqt.pool.common.security.SecurityUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class CommProductFeignClientInterceptor
implements RequestInterceptor {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER = "Bearer";

    public void apply(RequestTemplate template) {
        Optional<String> currentUserJWT = SecurityUtils.getCurrentUserJWT();
        if (currentUserJWT.isPresent()) {
            template.header(AUTHORIZATION_HEADER, new String[]{String.format("%s %s", BEARER, currentUserJWT.get())});
        } else {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes == null) {
                return;
            }
            HttpServletRequest request = attributes.getRequest();
            String token = request.getHeader(AUTHORIZATION_HEADER);
            template.header(AUTHORIZATION_HEADER, new String[]{token});
        }
    }
}

