/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.event;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.common.config.KafkaMessage;
import com.qqt.pool.common.config.ServerConfiguration;
import com.qqt.pool.common.dto.LogUsualDTO;
import com.qqt.pool.common.event.UsualLogEvent;
import com.qqt.pool.common.utils.KafkaProduceUtil;
import com.qqt.pool.common.utils.LogAbstractUtil;
import io.github.jhipster.config.JHipsterProperties;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class UsualLogListener {
    private static final Logger log = LoggerFactory.getLogger(UsualLogListener.class);
    @Autowired
    private KafkaProduceUtil kafkaProduceUtil;
    @Autowired
    private ServerConfiguration serverConfiguration;
    @Autowired
    private JHipsterProperties jHipsterProperties;
    @Value(value="${spring.profiles.active}")
    private String env;

    @Async
    @Order
    @EventListener(value={UsualLogEvent.class})
    public void saveUsualLog(UsualLogEvent event) {
        Map source = (Map)event.getSource();
        LogUsualDTO logUsual = (LogUsualDTO)source.get("info");
        logUsual.setEnv(this.env);
        LogAbstractUtil.addOtherInfoToLog(logUsual, this.jHipsterProperties, this.serverConfiguration);
        KafkaMessage kafkaMessage = new KafkaMessage();
        kafkaMessage.setChannel("pool_usual_log_" + this.env);
        kafkaMessage.setMessage(JSON.parseObject((String)JSON.toJSONString((Object)logUsual)));
        this.kafkaProduceUtil.sendMessage(kafkaMessage);
    }
}

