/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.event.listener.order;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.common.config.KafkaMessage;
import com.qqt.pool.common.dto.CommonMessageDO;
import com.qqt.pool.common.enumeration.ThirdOrderEventEnum;
import com.qqt.pool.common.event.order.CommonOrderSplitEvent;
import com.qqt.pool.common.utils.DateUtil;
import com.qqt.pool.common.utils.KafkaProduceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@Order(value=-100)
public class CommonOrderSplitEventListener
implements ApplicationListener<CommonOrderSplitEvent> {
    private final Logger log = LoggerFactory.getLogger(CommonOrderSplitEventListener.class);
    @Autowired
    private KafkaProduceUtil kafkaProduceUtil;
    @Value(value="${common.message}")
    private String commonMsg;

    public void onApplicationEvent(CommonOrderSplitEvent event) {
        CommonMessageDO message = new CommonMessageDO();
        message.setContent(JSON.toJSONString((Object)event.getOrder()));
        message.setCompanyId(event.getCompanyId());
        message.setType(ThirdOrderEventEnum.ORDER_SPLIT.getCode());
        message.setTime(DateUtil.nowOfStringByDateTime());
        message.setThirdCode(event.getThirdCode());
        message.setMsgType("ORDER");
        message.setToken(event.getToken());
        this.log.info("kafka send message : {}---", (Object)JSON.toJSONString((Object)message));
        KafkaMessage kafkaMessage = new KafkaMessage();
        kafkaMessage.setChannel(this.commonMsg);
        kafkaMessage.setMessage(JSON.parseObject((String)JSON.toJSONString((Object)message)));
        this.kafkaProduceUtil.sendMessage(kafkaMessage);
    }
}

