/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.sourcepool;

import com.qqt.pool.common.aop.UsualLogger;
import com.qqt.pool.common.config.ServerConfiguration;
import com.qqt.pool.common.service.SessionService;
import com.qqt.pool.common.sourcepool.SourcePoolLog;
import com.qqt.pool.common.utils.DateUtils;
import com.qqt.pool.common.utils.WeChatBotUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class SourcePoolLogAspect {
    private final Logger log = LoggerFactory.getLogger(SourcePoolLogAspect.class);
    @Autowired
    private UsualLogger usualLogger;
    @Value(value="${spring.profiles.active}")
    private String env;
    @Value(value="${source.pool.warnEnv:prod}")
    private String warnEnv;
    @Autowired
    private SessionService sessionService;
    @Autowired
    private ServerConfiguration serverConfiguration;
    private static final String warnMsg = "### \u805a\u6e90\u6c60\u63a5\u53e3\u9884\u8b66\uff1a\n\n```\n\u62a5\u9519\u670d\u52a1: %s\n\u8fd0\u884c\u73af\u5883: %s\nIP: %s\n\u65f6\u95f4: %s\n\u7528\u6237: %s\n\u63a5\u53e3: %s\n\u8c03\u7528\u65b9\u6cd5: %s\n\u53c2\u6570: %s\n\u62a5\u9519\u4fe1\u606f: %s\n```";

    @Pointcut(value="@annotation(com.qqt.pool.common.sourcepool.SourcePoolLog)")
    public void point() {
    }

    @Around(value="point()")
    public Object process(ProceedingJoinPoint pjp) throws Throwable {
        Object proceed = null;
        Object[] args = pjp.getArgs();
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method signatureMethod = signature.getMethod();
        String targetName = pjp.getTarget().getClass().getName();
        String methodName = pjp.getSignature().getName();
        this.log.info("\u6267\u884c\u7c7b:{},\u65b9\u6cd5:{},\u53c2\u6570:{} \u5f00\u59cb", new Object[]{targetName, methodName, Arrays.toString(args)});
        long start = System.currentTimeMillis();
        try {
            proceed = pjp.proceed(args);
        }
        catch (Throwable throwable) {
            SourcePoolLog sourcePoolRoute = signatureMethod.getAnnotation(SourcePoolLog.class);
            if (sourcePoolRoute.isWarning() && this.env.equals(this.warnEnv)) {
                WeChatBotUtils.sendMarKDownMsg(String.format(warnMsg, sourcePoolRoute.operationPlatform(), this.env, this.serverConfiguration.getIp(), DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"), this.sessionService.getCurrentCompanyName(), sourcePoolRoute.businessType(), methodName, Arrays.toString(args), throwable.getMessage()));
            }
            this.usualLogger.error("\u670d\u52a1\u4fe1\u606f:{},\u6267\u884c\u7c7b:{},\u65b9\u6cd5:{},\u53c2\u6570:{} ", this.serverConfiguration.getIpWithPort(), targetName, methodName, Arrays.toString(args));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.log.info("\u65b9\u6cd5{}, \u65b9\u6cd5{} \u7ed3\u675f", (Object)targetName, (Object)methodName);
        if (this.log.isInfoEnabled()) {
            this.log.info("\u6267\u884c\u7c7b:{}, \u65b9\u6cd5:{},\u603b\u5171\u8017\u65f6: {}ms", new Object[]{targetName, methodName, end - start});
        }
        return proceed;
    }
}

