/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;

public class DateUtils {
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_TIME_MINUTE_FORMAT = "yyyy-MM-dd HH:mm";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_FORMAT_NO_SPACER = "yyyyMMdd";
    public static final String MONTH_DAY_FORMAT_NO_SPACER = "MMdd";
    public static final String YEAR_MONTH_FORMAT_NO_SPACER = "yyyyMM";
    public static final Map<Pattern, String> SUPPORT_FORMAT_MAP = new ConcurrentHashMap<Pattern, String>();
    private static final Pattern DATE_TIME_PATTERN = Pattern.compile("^[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}$");
    private static final Pattern DATE_TIME_MINUTE_PATTERN = Pattern.compile("^[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}$");
    private static final Pattern DATE_PATTERN = Pattern.compile("^[0-9]{4}-[0-9]{2}-[0-9]{2}$");
    private static final Pattern DATE_PATTERN_NO_SPACER = Pattern.compile("^[0-9]{4}[0-9]{2}[0-9]{2}$");
    private static final Pattern MONTH_DAY_PATTERN_NO_SPACER = Pattern.compile("^[0-9]{2}[0-9]{2}$");
    private static final Pattern YEAR_MONTH_PATTERN_NO_SPACER = Pattern.compile("^[0-9]{4}[0-9]{2}$");
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat();

    private static Date convert(String dateString) {
        Date date = null;
        for (Pattern pattern : SUPPORT_FORMAT_MAP.keySet()) {
            Matcher matcher = pattern.matcher(dateString);
            if (!matcher.matches()) continue;
            try {
                String format = SUPPORT_FORMAT_MAP.get(pattern);
                date = new SimpleDateFormat(format).parse(dateString);
            }
            catch (ParseException parseException) {}
            break;
        }
        return date;
    }

    private static Date convert(String dateString, String format) {
        boolean matches = false;
        for (String _format : SUPPORT_FORMAT_MAP.values()) {
            if (!_format.equals(format)) continue;
            matches = true;
            break;
        }
        if (!matches) {
            throw new IllegalArgumentException(format + " is not a valid date format");
        }
        Date date = null;
        try {
            date = new SimpleDateFormat(format).parse(dateString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static Date parse(String dateText) {
        return DateUtils.convert(dateText);
    }

    public static Date parse(String dateText, String format) {
        return DateUtils.convert(dateText, format);
    }

    public static String format(Date date) {
        SIMPLE_DATE_FORMAT.applyPattern(DATE_TIME_FORMAT);
        return SIMPLE_DATE_FORMAT.format(date);
    }

    public static String format(Date date, String pattern) {
        SIMPLE_DATE_FORMAT.applyPattern(pattern);
        return SIMPLE_DATE_FORMAT.format(date);
    }

    public static String format(long timestamp) {
        SIMPLE_DATE_FORMAT.applyPattern(DATE_TIME_FORMAT);
        return SIMPLE_DATE_FORMAT.format(DateUtils.newDate(timestamp));
    }

    public static String format(long timestamp, String pattern) {
        SIMPLE_DATE_FORMAT.applyPattern(pattern);
        return SIMPLE_DATE_FORMAT.format(DateUtils.newDate(timestamp));
    }

    public static long format(String dateText) {
        return DateUtils.convert(dateText).getTime();
    }

    public static Date now() {
        return DateUtils.newDate(DateUtils.nowTimestamp());
    }

    public static long nowTimestamp() {
        return System.currentTimeMillis();
    }

    public static Date newDate(long timestamp) {
        return new Date(timestamp);
    }

    public static Date newDate(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        DateTime dateTime = new DateTime(year, month, day, hour, minute, second, millisecond);
        return dateTime.toDate();
    }

    public static Date newDate(int year, int month, int day, int hour, int minute, int second) {
        return DateUtils.newDate(year, month, day, hour, minute, second, 0);
    }

    public static Date newDate(int year, int month, int day, int hour, int minute) {
        return DateUtils.newDate(year, month, day, hour, minute, 0, 0);
    }

    public static Date newDate(int year, int month, int day, int hour) {
        return DateUtils.newDate(year, month, day, hour, 0, 0, 0);
    }

    public static Date newDate(int year, int month, int day) {
        return DateUtils.newDate(year, month, day, 0, 0, 0, 0);
    }

    public static Date add(Date date, int years, int months, int days, int hours, int minutes, int seconds, int milliseconds) {
        return DateUtils.add(date.getTime(), years, months, days, hours, minutes, seconds, milliseconds);
    }

    public static Date add(long timestamp, int years, int months, int days, int hours, int minutes, int seconds, int milliseconds) {
        int zero = 0;
        DateTime dateTime = new DateTime(timestamp);
        if (zero < years) {
            dateTime = dateTime.plusYears(years);
        } else if (zero > years) {
            dateTime = dateTime.minusYears(years);
        }
        if (zero < months) {
            dateTime = dateTime.plusMonths(months);
        } else if (zero > months) {
            dateTime = dateTime.minusMonths(months);
        }
        if (zero < days) {
            dateTime = dateTime.plusDays(days);
        } else if (zero > days) {
            dateTime = dateTime.minusDays(days);
        }
        if (zero < hours) {
            dateTime = dateTime.plusHours(hours);
        } else if (zero > hours) {
            dateTime = dateTime.minusHours(hours);
        }
        if (zero < minutes) {
            dateTime = dateTime.plusMinutes(minutes);
        } else if (zero > minutes) {
            dateTime = dateTime.minusMinutes(minutes);
        }
        if (zero < seconds) {
            dateTime = dateTime.plusSeconds(seconds);
        } else if (zero > seconds) {
            dateTime = dateTime.minusSeconds(seconds);
        }
        if (zero < milliseconds) {
            dateTime = dateTime.plusMillis(milliseconds);
        } else if (zero > milliseconds) {
            dateTime = dateTime.minusMillis(milliseconds);
        }
        return dateTime.toDate();
    }

    public static Long getWeekStart(long timestamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timestamp);
        Integer date = cal.get(5);
        cal.set(7, 2);
        if (cal.get(5) > date) {
            cal.add(5, -7);
        }
        Date time = cal.getTime();
        return DateUtils.format(new SimpleDateFormat(DATE_FORMAT).format(time) + " 00:00:00");
    }

    public static Long getWeekEnd(long timestamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timestamp);
        Integer date = cal.get(5);
        cal.set(7, 1);
        if (cal.get(5) < date) {
            cal.add(5, 7);
        }
        Date time = cal.getTime();
        return DateUtils.format(new SimpleDateFormat(DATE_FORMAT).format(time) + " 23:59:59");
    }

    public static Integer getDateVersion(long timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        calendar.setFirstDayOfWeek(2);
        return calendar.get(1) * 1000 + calendar.get(3);
    }

    public static Integer getNowVersion() {
        return DateUtils.getDateVersion(DateUtils.nowTimestamp());
    }

    public static Map<String, String> getYearMonthWeekStr(long timestamp) {
        Calendar cal;
        Calendar firstDay = Calendar.getInstance();
        firstDay.setTimeInMillis(timestamp);
        firstDay.set(5, 1);
        Calendar lastDay = Calendar.getInstance();
        lastDay.setTimeInMillis(timestamp);
        lastDay.add(2, 1);
        lastDay.set(5, 0);
        Calendar firsSunday = Calendar.getInstance();
        firsSunday.setTimeInMillis(firstDay.getTimeInMillis());
        firsSunday.set(7, 1);
        if (firsSunday.getTimeInMillis() != firstDay.getTimeInMillis()) {
            firsSunday.add(5, 7);
        }
        Calendar lastMonday = Calendar.getInstance();
        lastMonday.setTimeInMillis(lastDay.getTimeInMillis());
        lastMonday.set(7, 2);
        if (lastMonday.getTimeInMillis() > lastDay.getTimeInMillis()) {
            lastMonday.add(5, -7);
        }
        String year = "";
        String month = "";
        String week = "";
        SimpleDateFormat df = new SimpleDateFormat("MMM", Locale.ENGLISH);
        if (firsSunday.getTimeInMillis() >= timestamp) {
            if (firsSunday.get(5) > 3) {
                cal = Calendar.getInstance();
                cal.setTimeInMillis(timestamp);
                year = cal.get(1) + "";
                month = df.format(cal.getTime());
                week = cal.get(4) + "th Week";
            } else {
                Calendar preFirstDay = Calendar.getInstance();
                preFirstDay.setTimeInMillis(timestamp);
                preFirstDay.set(5, 1);
                preFirstDay.add(2, -1);
                Calendar preFirsSunday = Calendar.getInstance();
                preFirsSunday.setTimeInMillis(preFirstDay.getTimeInMillis());
                preFirsSunday.set(7, 1);
                if (preFirsSunday.getTimeInMillis() != preFirstDay.getTimeInMillis()) {
                    preFirsSunday.add(5, 7);
                }
                Calendar preLastDay = Calendar.getInstance();
                preLastDay.setTimeInMillis(firstDay.getTimeInMillis());
                preLastDay.add(5, -1);
                year = preLastDay.get(1) + "";
                month = df.format(preLastDay.getTime());
                week = preFirsSunday.get(5) > 3 ? preLastDay.get(4) + "th Week" : preLastDay.get(4) - 1 + "th Week";
            }
        } else if (lastMonday.getTimeInMillis() <= timestamp) {
            if (lastDay.get(7) >= 5 || lastDay.get(7) == 1) {
                cal = Calendar.getInstance();
                cal.setTimeInMillis(timestamp);
                year = cal.get(1) + "";
                month = df.format(cal.getTime());
                week = firsSunday.get(5) > 3 ? cal.get(4) + "th Week" : cal.get(4) - 1 + "th Week";
            } else {
                Calendar nextFirstDay = Calendar.getInstance();
                nextFirstDay.setTimeInMillis(timestamp);
                nextFirstDay.add(2, 1);
                nextFirstDay.set(5, 1);
                year = nextFirstDay.get(1) + "";
                month = df.format(nextFirstDay.getTime());
                week = nextFirstDay.get(4) + "th Week";
            }
        } else {
            cal = Calendar.getInstance();
            cal.setTimeInMillis(timestamp);
            year = cal.get(1) + "";
            month = df.format(cal.getTime());
            week = firsSunday.get(5) > 3 ? cal.get(4) + "th Week" : cal.get(4) - 1 + "th Week";
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("year", year);
        result.put("month", month);
        result.put("week", week);
        return result;
    }

    public static Date addYears(Date date, int years) {
        return DateUtils.addYears(date.getTime(), years);
    }

    public static Date addYears(long timestamp, int years) {
        return DateUtils.add(timestamp, years, 0, 0, 0, 0, 0, 0);
    }

    public static Date addMonths(Date date, int months) {
        return DateUtils.addMonths(date.getTime(), months);
    }

    public static Date addMonths(long timestamp, int months) {
        return DateUtils.add(timestamp, 0, months, 0, 0, 0, 0, 0);
    }

    public static Date addDays(Date date, int days) {
        return DateUtils.addDays(date.getTime(), days);
    }

    public static Date addDays(long timestamp, int days) {
        return DateUtils.add(timestamp, 0, 0, days, 0, 0, 0, 0);
    }

    public static Date addHours(Date date, int hours) {
        return DateUtils.addHours(date.getTime(), hours);
    }

    public static Date addHours(long timestamp, int hours) {
        return DateUtils.add(timestamp, 0, 0, 0, hours, 0, 0, 0);
    }

    public static Date addMinutes(Date date, int minutes) {
        return DateUtils.addMinutes(date.getTime(), minutes);
    }

    public static Date addMinutes(long timestamp, int minutes) {
        return DateUtils.add(timestamp, 0, 0, 0, 0, minutes, 0, 0);
    }

    public static int getCurrentMonth() {
        DateTime dateTime = DateTime.now();
        return dateTime.getMonthOfYear();
    }

    static {
        SUPPORT_FORMAT_MAP.put(DATE_TIME_PATTERN, DATE_TIME_FORMAT);
        SUPPORT_FORMAT_MAP.put(DATE_TIME_MINUTE_PATTERN, DATE_TIME_MINUTE_FORMAT);
        SUPPORT_FORMAT_MAP.put(DATE_PATTERN, DATE_FORMAT);
        SUPPORT_FORMAT_MAP.put(DATE_PATTERN_NO_SPACER, DATE_FORMAT_NO_SPACER);
        SUPPORT_FORMAT_MAP.put(YEAR_MONTH_PATTERN_NO_SPACER, YEAR_MONTH_FORMAT_NO_SPACER);
        SUPPORT_FORMAT_MAP.put(MONTH_DAY_PATTERN_NO_SPACER, MONTH_DAY_FORMAT_NO_SPACER);
    }
}

