/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.event.listener.order;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.common.config.KafkaMessage;
import com.qqt.pool.common.dto.CommonMessageDO;
import com.qqt.pool.common.dto.platform.UpdateMessageDO;
import com.qqt.pool.common.enumeration.ThirdOrderEventEnum;
import com.qqt.pool.common.event.order.CommonBillChangeEvent;
import com.qqt.pool.common.utils.DateUtil;
import com.qqt.pool.common.utils.KafkaProduceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@Order(value=-100)
public class CommonBillChangeEventListener
implements ApplicationListener<CommonBillChangeEvent> {
    @Autowired
    private KafkaProduceUtil kafkaProduceUtil;
    @Value(value="${common.message}")
    private String commonMsg;

    public void onApplicationEvent(CommonBillChangeEvent event) {
        UpdateMessageDO ud = new UpdateMessageDO();
        ud.setCode(event.getThirdCode());
        ud.setDataId(event.getBillId());
        ud.setStatus(event.getStatus());
        ud.setCustomerCompanyId(event.getCustomerCompanyId());
        ud.setDataDOList(event.getDataDOS());
        CommonMessageDO message = new CommonMessageDO();
        message.setContent(JSON.toJSONString((Object)ud));
        message.setCompanyId(event.getCompanyId());
        message.setType(ThirdOrderEventEnum.BILL_CHANGE.getCode());
        message.setTime(DateUtil.nowOfStringByDateTime());
        message.setMsgType("ORDER");
        message.setToken(event.getToken());
        message.setThirdCode(event.getThirdCode());
        KafkaMessage kafkaMessage = new KafkaMessage();
        kafkaMessage.setChannel(this.commonMsg);
        kafkaMessage.setMessage(JSON.parseObject((String)JSON.toJSONString((Object)message)));
        this.kafkaProduceUtil.sendMessage(kafkaMessage);
    }
}

