/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.utils;

import com.qqt.pool.common.utils.ClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.lang.Nullable;

public class BeanUtil
extends BeanUtils {
    public static <T> T newInstance(Class<?> clazz) {
        return (T)BeanUtil.instantiateClass(clazz);
    }

    public static <T> T newInstance(String clazzStr) {
        try {
            Class clazz = ClassUtil.forName((String)clazzStr, null);
            return BeanUtil.newInstance(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static Object getProperty(@Nullable Object bean, String propertyName) {
        if (bean == null) {
            return null;
        }
        BeanWrapper beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        return beanWrapper.getPropertyValue(propertyName);
    }

    public static void setProperty(Object bean, String propertyName, Object value) {
        Objects.requireNonNull(bean, "bean Could not null");
        BeanWrapper beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        beanWrapper.setPropertyValue(propertyName, value);
    }

    @Nullable
    public static <T> T copyProperties(@Nullable Object source, Class<T> targetClazz) throws BeansException {
        if (source == null) {
            return null;
        }
        T to = BeanUtil.newInstance(targetClazz);
        BeanUtil.copyProperties((Object)source, to);
        return to;
    }

    public static <T> List<T> copyProperties(@Nullable Collection<?> sourceList, Class<T> targetClazz) throws BeansException {
        if (sourceList == null || sourceList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> outList = new ArrayList<T>(sourceList.size());
        for (Object source : sourceList) {
            if (source == null) continue;
            T bean = BeanUtil.copyProperties(source, targetClazz);
            outList.add(bean);
        }
        return outList;
    }
}

