/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.event;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.common.config.KafkaMessage;
import com.qqt.pool.common.config.ServerConfiguration;
import com.qqt.pool.common.dto.ThirdLogApiDO;
import com.qqt.pool.common.event.ThirdLogEvent;
import com.qqt.pool.common.utils.KafkaProduceUtil;
import io.github.jhipster.config.JHipsterProperties;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ThirdApiLogListener {
    private static final Logger log = LoggerFactory.getLogger(ThirdApiLogListener.class);
    @Autowired
    private KafkaProduceUtil kafkaProduceUtil;
    @Autowired
    private ServerConfiguration serverConfiguration;
    @Autowired
    private JHipsterProperties jHipsterProperties;
    @Value(value="${spring.profiles.active}")
    private String env;

    @Async
    @Order
    @EventListener(value={ThirdLogEvent.class})
    public void saveApiLog(ThirdLogEvent event) {
        Map source = (Map)event.getSource();
        ThirdLogApiDO logApi = (ThirdLogApiDO)source.get("info");
        logApi.setEnv(this.env);
        KafkaMessage kafkaMessage = new KafkaMessage();
        kafkaMessage.setChannel("pool_third_api_log_" + this.env);
        kafkaMessage.setMessage(JSON.parseObject((String)JSON.toJSONString((Object)logApi)));
        this.kafkaProduceUtil.sendMessage(kafkaMessage);
    }
}

