/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.event.listener.order;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.common.config.KafkaMessage;
import com.qqt.pool.common.dto.CommonMessageDO;
import com.qqt.pool.common.enumeration.ThirdOrderEventEnum;
import com.qqt.pool.common.event.order.CommonInvoiceCreatedEvent;
import com.qqt.pool.common.utils.DateUtil;
import com.qqt.pool.common.utils.KafkaProduceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@Order(value=-100)
public class CommonInvoiceCreateEventListener
implements ApplicationListener<CommonInvoiceCreatedEvent> {
    @Autowired
    private KafkaProduceUtil kafkaProduceUtil;
    @Value(value="${common.message}")
    private String commonMsg;

    public void onApplicationEvent(CommonInvoiceCreatedEvent event) {
        CommonMessageDO message = new CommonMessageDO();
        message.setCompanyId(event.getCompanyId());
        message.setType(ThirdOrderEventEnum.INVOICE_CREATE.getCode());
        message.setTime(DateUtil.nowOfStringByDateTime());
        message.setContent(JSON.toJSONString((Object)event.getInvoiceApplyDO()));
        message.setMsgType("ORDER");
        message.setToken(event.getToken());
        message.setThirdCode(event.getThirdCode());
        KafkaMessage kafkaMessage = new KafkaMessage();
        kafkaMessage.setChannel(this.commonMsg);
        kafkaMessage.setMessage(JSON.parseObject((String)JSON.toJSONString((Object)message)));
        this.kafkaProduceUtil.sendMessage(kafkaMessage);
    }
}

