/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.utils;

import com.qqt.pool.common.dto.ResultDTO;
import com.qqt.pool.common.utils.ResultTemplateBody;
import com.qqt.pool.common.utils.ResultUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ResultTemplate {
    public static final Logger LOGGER = LoggerFactory.getLogger(ResultTemplate.class);

    public static ResultDTO invoke(ResultTemplateBody resultTemplateBody, ResultTemplateAction action, String defaultMsg) {
        ResultDTO<Object> resultDTO;
        try {
            Object data = resultTemplateBody.execute();
            resultDTO = ResultUtil.success(data);
            resultDTO.setMsg(ResultTemplate.getMessage(true, action, defaultMsg));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("invoke error", (Throwable)e);
            resultDTO = ResultUtil.fail(e.getMessage());
            resultDTO.setMsg(ResultTemplate.getMessage(false, action, defaultMsg) + e.getMessage());
        }
        return resultDTO;
    }

    public static ResultDTO invoke(ResultTemplateBody resultTemplateBody, ResultTemplateAction action) {
        return ResultTemplate.invoke(resultTemplateBody, action, null);
    }

    public static ResultDTO invoke(ResultTemplateBody resultTemplateBody, String action) {
        return ResultTemplate.invoke(resultTemplateBody, ResultTemplateAction.EXECUTE, action);
    }

    public static ResultDTO invoke(ResultTemplateBody resultTemplateBody) {
        return ResultTemplate.invoke(resultTemplateBody, ResultTemplateAction.EXECUTE, null);
    }

    public static String getMessage(boolean successStus, ResultTemplateAction action, String defaultMsg) {
        String actionMsg;
        String success;
        String string = success = successStus ? "\u6210\u529f!" : "\u5931\u8d25!";
        if (StringUtils.isEmpty((Object)defaultMsg)) {
            switch (action) {
                case EXECUTE: {
                    actionMsg = "\u6267\u884c";
                    break;
                }
                case CREATE: {
                    actionMsg = "\u65b0\u589e";
                    break;
                }
                case UPDATE: {
                    actionMsg = "\u4fee\u6539";
                    break;
                }
                case DELETE: {
                    actionMsg = "\u5220\u9664";
                    break;
                }
                case QUERY: {
                    actionMsg = "\u67e5\u8be2";
                    break;
                }
                default: {
                    actionMsg = "\u6267\u884c";
                    break;
                }
            }
        } else {
            actionMsg = defaultMsg;
        }
        return actionMsg + success;
    }

    public static enum ResultTemplateAction {
        CREATE,
        UPDATE,
        DELETE,
        QUERY,
        EXECUTE;

    }
}

