/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.utils;

import com.qqt.pool.common.event.order.CommonBillChangeEvent;
import com.qqt.pool.common.event.order.CommonBillCreateEvent;
import com.qqt.pool.common.event.order.CommonConsignmentChangeEvent;
import com.qqt.pool.common.event.order.CommonConsignmentCreateEvent;
import com.qqt.pool.common.event.order.CommonInvoiceChangeEvent;
import com.qqt.pool.common.event.order.CommonInvoiceCreatedEvent;
import com.qqt.pool.common.event.order.CommonOrderChangeEvent;
import com.qqt.pool.common.event.order.CommonOrderCreatedEvent;
import com.qqt.pool.common.event.order.CommonOrderSplitEvent;
import com.qqt.pool.common.event.order.CommonReturnOrderChangeEvent;
import com.qqt.pool.common.event.order.CommonReturnOrderCreateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;

@Component
public class SpringUtils
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringUtils.class);
    private static ApplicationContext applicationContext;

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringUtils.applicationContext = applicationContext;
    }

    public static Object getBean(String name) {
        return applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> type) {
        return (T)applicationContext.getBean(type);
    }

    public static void publishEvent(ApplicationEvent event) {
        if (applicationContext == null) {
            return;
        }
        try {
            applicationContext.publishEvent(event);
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
        }
    }

    public static void publishEvent(CommonOrderCreatedEvent event) {
        if (applicationContext == null) {
            return;
        }
        log.info("\u8ba2\u5355\u521b\u5efa\u4e8b\u4ef6\u53d1\u5e03\uff1a\u7b2c\u4e09\u65b9\uff1a{}\uff0c\u8ba2\u5355\u7f16\u53f7\uff1a{}\uff0c\u516c\u53f8id\uff1a{}", new Object[]{event.getThirdCode(), event.getOrderId(), event.getCompanyId()});
        try {
            applicationContext.publishEvent((ApplicationEvent)event);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    public static void publishEvent(CommonOrderChangeEvent event) {
        if (applicationContext == null) {
            return;
        }
        log.info("\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u4e8b\u4ef6\u53d1\u5e03\uff1a\u7b2c\u4e09\u65b9\uff1a{}\uff0c\u8ba2\u5355\u7f16\u53f7\uff1a{}\uff0c\u516c\u53f8id\uff1a{}", new Object[]{event.getThirdCode(), event.getOrderId(), event.getCompanyId()});
        try {
            applicationContext.publishEvent((ApplicationEvent)event);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    public static void publishEvent(CommonOrderSplitEvent event) {
        if (applicationContext == null) {
            return;
        }
        log.info("\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u4e8b\u4ef6\u53d1\u5e03\uff1a\u7b2c\u4e09\u65b9\uff1a{}\uff0c\u7236\u8ba2\u5355\u7f16\u53f7\uff1a{}\uff0c\u5b50\u8ba2\u5355\u7f16\u53f7\uff1a{}\uff0c\u516c\u53f8id\uff1a{}", new Object[]{event.getThirdCode(), event.getOrder().getParentThirdCode(), event.getOrder().getOuterSysACode(), event.getCompanyId()});
        try {
            applicationContext.publishEvent((ApplicationEvent)event);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    public static void publishEvent(CommonConsignmentCreateEvent event) {
        if (applicationContext == null) {
            return;
        }
        log.info("\u751f\u6210\u53d1\u8d27\u5355\u4e8b\u4ef6\u53d1\u5e03\uff1a\u7b2c\u4e09\u65b9\uff1a{}\uff0c\u53d1\u8d27\u5355\u7f16\u53f7\uff1a{}\uff0c\u516c\u53f8id\uff1a{}", new Object[]{event.getThirdCode(), event.getConsignmentDO().getCode(), event.getCompanyId()});
        try {
            applicationContext.publishEvent((ApplicationEvent)event);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    public static void publishEvent(CommonConsignmentChangeEvent event) {
        if (applicationContext == null) {
            return;
        }
        log.info("\u53d1\u8d27\u5355\u72b6\u6001\u53d8\u66f4\u4e8b\u4ef6\u53d1\u5e03\uff1a\u7b2c\u4e09\u65b9\uff1a{}\uff0c\u53d1\u8d27\u5355\u7f16\u53f7\uff1a{}\uff0c\u516c\u53f8id\uff1a{}", new Object[]{event.getThirdCode(), event.getPackageId(), event.getCompanyId()});
        try {
            applicationContext.publishEvent((ApplicationEvent)event);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    public static void publishEvent(CommonInvoiceCreatedEvent event) {
        if (applicationContext == null) {
            return;
        }
        log.info("\u53d1\u7968\u7533\u8bf7\u4e8b\u4ef6\u53d1\u5e03\uff1a\u7b2c\u4e09\u65b9\uff1a{}\uff0c\u53d1\u7968\u7533\u8bf7\u5355\u53f7\uff1a{}\uff0c\u516c\u53f8id\uff1a{}", new Object[]{event.getThirdCode(), event.getInvoiceApplyDO().getMarkId(), event.getCompanyId()});
        try {
            applicationContext.publishEvent((ApplicationEvent)event);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    public static void publishEvent(CommonInvoiceChangeEvent event) {
        if (applicationContext == null) {
            return;
        }
        log.info("\u53d1\u7968\u72b6\u6001\u53d8\u66f4\u4e8b\u4ef6\u53d1\u5e03\uff1a\u7b2c\u4e09\u65b9\uff1a{}\uff0c\u53d1\u7968\u7533\u8bf7\u5355\u53f7\uff1a{}\uff0c\u516c\u53f8id\uff1a{}", new Object[]{event.getThirdCode(), event.getMarkId(), event.getCompanyId()});
        try {
            applicationContext.publishEvent((ApplicationEvent)event);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    public static void publishEvent(CommonBillCreateEvent event) {
        if (applicationContext == null) {
            return;
        }
        log.info("\u63a8\u9001\u5bf9\u8d26\u5355\u4e8b\u4ef6\u53d1\u5e03\uff1a\u7b2c\u4e09\u65b9\uff1a{}\uff0c\u5bf9\u8d26\u5355\u53f7\uff1a{}\uff0c\u516c\u53f8id\uff1a{}", new Object[]{event.getThirdCode(), event.getBillDO().getStatementId(), event.getCompanyId()});
        try {
            applicationContext.publishEvent((ApplicationEvent)event);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    public static void publishEvent(CommonBillChangeEvent event) {
        if (applicationContext == null) {
            return;
        }
        log.info("\u5bf9\u8d26\u5355\u72b6\u6001\u53d8\u66f4\u4e8b\u4ef6\u53d1\u5e03\uff1a\u7b2c\u4e09\u65b9\uff1a{}\uff0c\u5bf9\u8d26\u5355\u53f7\uff1a{}\uff0c\u516c\u53f8id\uff1a{}", new Object[]{event.getThirdCode(), event.getBillId(), event.getCompanyId()});
        try {
            applicationContext.publishEvent((ApplicationEvent)event);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    public static void publishEvent(CommonReturnOrderCreateEvent event) {
        if (applicationContext == null) {
            return;
        }
        log.info("\u552e\u540e\u5355\u7533\u8bf7\u4e8b\u4ef6\u53d1\u5e03\uff1a\u7b2c\u4e09\u65b9\uff1a{}\uff0c\u552e\u540e\u5355\u53f7\uff1a{}\uff0c\u516c\u53f8id\uff1a{}", new Object[]{event.getThirdCode(), event.getReturnOrderDO().getOuterSysCode(), event.getCompanyId()});
        try {
            applicationContext.publishEvent((ApplicationEvent)event);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    public static void publishEvent(CommonReturnOrderChangeEvent event) {
        if (applicationContext == null) {
            return;
        }
        log.info("\u552e\u540e\u5355\u72b6\u6001\u53d8\u66f4\u4e8b\u4ef6\u53d1\u5e03\uff1a\u7b2c\u4e09\u65b9\uff1a{}\uff0c\u552e\u540e\u5355\u53f7\uff1a{}\uff0c\u516c\u53f8id\uff1a{}", new Object[]{event.getThirdCode(), event.getReturnOrderId(), event.getCompanyId()});
        try {
            applicationContext.publishEvent((ApplicationEvent)event);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }
}

