/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.aop;

import com.qqt.pool.common.dto.ResultDTO;
import com.qqt.pool.common.enumeration.ErrorEnum;
import com.qqt.pool.common.exception.RRException;
import com.qqt.pool.common.utils.ResultUtil;
import java.sql.SQLException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Order(value=1)
@RestControllerAdvice
public class GlobalExceptionHandlerAdvice {
    private final Logger log = LoggerFactory.getLogger(GlobalExceptionHandlerAdvice.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResultDTO validParamHandler(MethodArgumentNotValidException e) {
        this.log.error("@Valid \u6821\u9a8c\u5f02\u5e38\u5904\u7406:{}", (Throwable)e);
        BindingResult bindingResult = e.getBindingResult();
        return this.fillResultDTO(bindingResult);
    }

    @ExceptionHandler(value={BindException.class})
    public ResultDTO validParamHandler(BindException e) {
        this.log.error("@Valid BindException\u6821\u9a8c\u5f02\u5e38\u5904\u7406:{}", (Throwable)e);
        BindingResult bindingResult = e.getBindingResult();
        return this.fillResultDTO(bindingResult);
    }

    private ResultDTO fillResultDTO(BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            HashMap errors = new HashMap();
            bindingResult.getAllErrors().forEach(error -> {
                FieldError fieldError = (FieldError)error;
                errors.put(fieldError.getField(), fieldError.getDefaultMessage());
            });
            return ResultUtil.fail(Integer.parseInt(ErrorEnum.VALID_PARAMS_1101.getErrCode()), errors, ErrorEnum.VALID_PARAMS_1101.getErrMsg());
        }
        return ResultUtil.fail(Integer.parseInt(ErrorEnum.VALID_PARAMS_1101.getErrCode()), ErrorEnum.VALID_PARAMS_1101.getErrMsg());
    }

    @ExceptionHandler(value={SQLException.class})
    public ResultDTO sqlExceptionHandler(SQLException e) {
        this.log.error("sql\u5f02\u5e38\u5904\u7406:{}", (Throwable)e);
        return ResultUtil.fail("\u7cfb\u7edf\u4e0d\u652f\u6301\u7279\u6b8a\u5b57\u7b26\u6216\u8868\u5f02\u5e38");
    }

    @ExceptionHandler(value={RRException.class})
    @ResponseBody
    public ResultDTO handleRRException(RRException e) {
        ResultDTO resultDTO = new ResultDTO();
        resultDTO.setCode(e.getCode());
        resultDTO.setMsg(e.getMsg());
        return resultDTO;
    }
}

