/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.facade.mapper;

import cn.hutool.core.util.NumberUtil;
import com.qqt.pool.common.domain.AbstractCompanyEntity;
import com.qqt.pool.common.domain.IAuditingEntity;
import com.qqt.pool.common.dto.CompanyDO;
import com.qqt.pool.common.service.dto.AbstractAuditingDTO;
import com.qqt.pool.common.utils.AdminEntityCacheUtils;
import java.util.List;
import org.mapstruct.AfterMapping;
import org.mapstruct.MappingTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public abstract class AuditingDTOMapper<DTO extends AbstractAuditingDTO, Entity extends IAuditingEntity> {
    private static final Logger logger = LoggerFactory.getLogger(AuditingDTOMapper.class);
    @Autowired
    private AdminEntityCacheUtils adminEntityCacheUtils;

    public abstract Entity toEntity(DTO var1);

    @AfterMapping
    protected void fillAuditing(Entity auditingEntity, @MappingTarget DTO auditingDTO) {
        String userName;
        String createdBy = auditingEntity.getCreatedBy();
        ((AbstractAuditingDTO)auditingDTO).setCreatedName(createdBy);
        String lastModifiedBy = auditingEntity.getLastModifiedBy();
        ((AbstractAuditingDTO)auditingDTO).setLastModifiedName(lastModifiedBy);
        Boolean lastModifiedSetted = Boolean.FALSE;
        try {
            if (NumberUtil.isNumber((CharSequence)createdBy) && !StringUtils.isEmpty((Object)(userName = this.adminEntityCacheUtils.getUserName(Long.parseLong(createdBy))))) {
                ((AbstractAuditingDTO)auditingDTO).setCreatedName(userName);
                if (NumberUtil.isNumber((CharSequence)lastModifiedBy) && lastModifiedBy.equals(createdBy)) {
                    ((AbstractAuditingDTO)auditingDTO).setLastModifiedName(userName);
                    lastModifiedSetted = Boolean.TRUE;
                }
            }
        }
        catch (Exception e) {
            logger.error("getUserDetailByCode CreatedBy error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
        }
        if (!lastModifiedSetted.booleanValue()) {
            try {
                if (NumberUtil.isNumber((CharSequence)lastModifiedBy) && !StringUtils.isEmpty((Object)(userName = this.adminEntityCacheUtils.getUserName(Long.parseLong(lastModifiedBy))))) {
                    ((AbstractAuditingDTO)auditingDTO).setLastModifiedName(userName);
                }
            }
            catch (Exception e) {
                logger.error("getUserDetailByCode LastModifiedBy error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
            }
        }
        Long companyId = null;
        if (auditingEntity instanceof AbstractCompanyEntity) {
            AbstractCompanyEntity companyEntity = (AbstractCompanyEntity)auditingEntity;
            if (companyEntity.getCompanyId() != null && companyEntity.getCompanyId() > 0L) {
                companyId = companyEntity.getCompanyId();
            }
        } else if (null != ((AbstractAuditingDTO)auditingDTO).getCompanyId()) {
            companyId = ((AbstractAuditingDTO)auditingDTO).getCompanyId();
        }
        if (null != companyId) {
            try {
                CompanyDO companyDO = this.adminEntityCacheUtils.getCompanyDO(companyId);
                if (companyDO != null) {
                    ((AbstractAuditingDTO)auditingDTO).setCompanyId(companyDO.getId());
                    ((AbstractAuditingDTO)auditingDTO).setCompanyCode(companyDO.getCode());
                    ((AbstractAuditingDTO)auditingDTO).setCompanyName(companyDO.getName());
                }
            }
            catch (Exception e) {
                logger.error("getCompanyById error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
            }
        }
    }

    public abstract DTO toDto(Entity var1);

    public abstract List<Entity> toEntity(List<DTO> var1);

    public abstract List<DTO> toDto(List<Entity> var1);
}

