/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.log;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.qqt.pool.common.dto.ResultDTO;
import com.qqt.pool.common.log.IgnoreOptLog;
import com.qqt.pool.common.log.OptLogDTO;
import com.qqt.pool.common.log.OptUserDTO;
import com.qqt.pool.common.service.SessionService;
import com.qqt.pool.common.service.bo.UserSession;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Component
@Aspect
@Order(value=-2147483648)
public class GlobalLogAspectConfig {
    private static final Logger log = LoggerFactory.getLogger(GlobalLogAspectConfig.class);
    @Autowired
    private SessionService sessionService;
    @Resource
    private Environment environment;

    @Pointcut(value="within(@org.springframework.web.bind.annotation.RestController *)")
    public void apiPointCut() {
    }

    @Around(value="apiPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        HttpServletResponse response = requestAttributes.getResponse();
        String requestRequestURI = request.getRequestURI();
        long startTime = System.currentTimeMillis();
        try {
            OptLogDTO optLogDTO = this.buildOptLog(point, request);
            OptUserDTO optUserDTO = (OptUserDTO)BeanUtil.copyProperties((Object)optLogDTO, OptUserDTO.class, (String[])new String[0]);
            String requestParams = optLogDTO.getRequestParams();
            int pringLogMaxSize = 5000;
            if (StrUtil.isNotBlank((CharSequence)requestParams) && requestParams.length() > pringLogMaxSize) {
                requestParams = requestParams.substring(0, pringLogMaxSize);
            }
            log.info("\u8bf7\u6c42\u63a5\u53e3={}|\u8bf7\u6c42\u65b9\u6cd5={}|\u8bf7\u6c42\u53c2\u6570={}", new Object[]{request.getRequestURI(), request.getMethod(), requestParams});
            log.info("\u64cd\u4f5c\u4eba\u4fe1\u606f={}", (Object)JSON.toJSONString((Object)optUserDTO));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(String.format("\u6267\u884c\u8bf7\u6c42%s\u5f02\u5e38", request.getRequestURI()), (Throwable)e);
        }
        try {
            ResponseEntity responseEntity;
            Object respBody;
            Object processResult = point.proceed();
            if (processResult instanceof ResultDTO) {
                ResultDTO resultDTO = (ResultDTO)processResult;
                resultDTO.setTraceId(MDC.get((String)"traceId"));
            }
            if (processResult instanceof ResponseEntity && Objects.nonNull(respBody = (responseEntity = (ResponseEntity)processResult).getBody()) && respBody instanceof ResultDTO) {
                ResultDTO respBodyRD = (ResultDTO)respBody;
                respBodyRD.setTraceId(MDC.get((String)"traceId"));
            }
            return processResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(String.format("\u6267\u884c\u8bf7\u6c42%s\u5f02\u5e38", request.getRequestURI()), (Throwable)e);
            throw e;
        }
    }

    private String getEnv() {
        return this.environment.getProperty("spring.profiles.active");
    }

    private OptLogDTO buildOptLog(ProceedingJoinPoint joinPoint, HttpServletRequest request) {
        Class<?> controllerClass = joinPoint.getTarget().getClass();
        String className = controllerClass.getName();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getName();
        String classMethod = className + "." + methodName;
        Method method = signature.getMethod();
        IgnoreOptLog ignoreOptLog = method.getAnnotation(IgnoreOptLog.class);
        if (ignoreOptLog != null) {
            return null;
        }
        Api api = controllerClass.getAnnotation(Api.class);
        ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
        String[] tagsArray = Optional.ofNullable(api).map(Api::tags).orElse(new String[]{"\u7c7b\u672a\u6dfb\u52a0@Api\u6ce8\u89e3"});
        String classTags = Arrays.stream(tagsArray).collect(Collectors.joining(","));
        String apiOperationTags = Optional.ofNullable(apiOperation).map(ApiOperation::value).orElse("\u63a5\u53e3\u672a\u6dfb\u52a0@ApiOperation\u6ce8\u89e3");
        String apiTags = classTags + "-" + apiOperationTags;
        UserSession userSession = this.sessionService.getSessionInfo();
        Map<String, Object> params = this.getParameters(joinPoint, request);
        String requestParams = this.toJsonStr(params);
        OptLogDTO optLogDTO = new OptLogDTO();
        optLogDTO.setEnv(this.getEnv());
        optLogDTO.setModule(this.environment.getProperty("spring.application.name"));
        optLogDTO.setTraceId(MDC.get((String)"traceId"));
        optLogDTO.setHttpMethod(request.getMethod());
        optLogDTO.setRequestUrl(request.getRequestURI());
        optLogDTO.setRequestParams(requestParams);
        optLogDTO.setClassMethod(classMethod);
        optLogDTO.setApiTags(apiTags);
        optLogDTO.setSourceIp(this.getSourceAddress());
        optLogDTO.setUserId(userSession.getUserId());
        optLogDTO.setUserName(userSession.getUserName());
        optLogDTO.setCompanyId(userSession.getCompanyId());
        optLogDTO.setCompanyCode(userSession.getCompanyCode());
        optLogDTO.setCompanyName(userSession.getCompanyName());
        optLogDTO.setSiteCode(userSession.getSiteCode());
        return optLogDTO;
    }

    private String getSourceAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                return "unkonw address";
            }
        }
    }

    private String toJsonStr(Map<String, Object> paramMap) {
        Object rawJson = paramMap.get("rawJson");
        if (rawJson != null) {
            return rawJson.toString();
        }
        return JSON.toJSONString(paramMap);
    }

    private Map<String, Object> getParameters(ProceedingJoinPoint point, HttpServletRequest request) {
        MethodSignature ms = (MethodSignature)point.getSignature();
        String[] parameterNames = ms.getParameterNames();
        Object[] args = point.getArgs();
        HashMap paramMap = Maps.newHashMap();
        for (int i = 0; i < parameterNames.length; ++i) {
            if (!(args[i] instanceof Serializable) || args[i] instanceof MultipartFile) continue;
            paramMap.put(parameterNames[i], args[i]);
        }
        if (CollUtil.isNotEmpty((Map)paramMap)) {
            return paramMap;
        }
        String contentType = request.getContentType();
        if (StrUtil.isNotBlank((CharSequence)contentType) && contentType.toLowerCase().contains("json")) {
            try {
                String jsonBody = IoUtil.read((InputStream)request.getInputStream()).toString();
                paramMap.put("rawJson", jsonBody);
                return paramMap;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return paramMap;
    }
}

