/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.orm;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.qqt.pool.common.orm.MetaModelField;
import com.qqt.pool.common.orm.ParseHandler;
import com.qqt.pool.common.orm.ParserContext;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ParseOrderByCondHandler
implements ParseHandler {
    private JSONObject queryObject;
    private Map<String, MetaModelField> modelFieldToTableField;

    @Override
    public void apply(ParserContext parserContext) {
        Set requestSortFieldSet;
        HashSet defineOrderByCommandSet = Sets.newHashSet();
        defineOrderByCommandSet.add("orderByDesc");
        defineOrderByCommandSet.add("orderByAsc");
        Set annotationSortFieldSet = this.modelFieldToTableField.values().stream().filter(metaModelField -> metaModelField.isOrderByAsc() || metaModelField.isOrderByDesc()).collect(Collectors.toSet());
        if (CollectionUtil.isNotEmpty(annotationSortFieldSet)) {
            for (MetaModelField metaModelField2 : annotationSortFieldSet) {
                String sortOperation = metaModelField2.isOrderByDesc() ? "orderByDesc" : "orderByAsc";
                if (this.queryObject.containsKey((Object)sortOperation)) continue;
                String sortFieldName = metaModelField2.getClassFieldName();
                this.queryObject.put(sortOperation, (Object)sortFieldName);
            }
        }
        if (CollectionUtil.isEmpty(requestSortFieldSet = this.queryObject.entrySet().stream().filter(entry -> {
            String key = (String)entry.getKey();
            boolean isContainsKey = defineOrderByCommandSet.contains(key);
            Object columns = this.queryObject.get((Object)key);
            return isContainsKey && columns != null && StrUtil.isNotBlank((CharSequence)columns.toString());
        }).map(Map.Entry::getKey).collect(Collectors.toSet()))) {
            return;
        }
        for (String orderByCommand : requestSortFieldSet) {
            String orderByFields = this.queryObject.getString(orderByCommand);
            Object[] orderByModelFieldArray = orderByFields.split(",");
            List orderByTableFieldNameList = Lists.newArrayList((Object[])orderByModelFieldArray).stream().map(orderByModelField -> this.modelFieldToTableField.get(orderByModelField)).map(MetaModelField::getTableFieldName).collect(Collectors.toList());
            for (String orderByTableFieldName : orderByTableFieldNameList) {
                parserContext.addOrderByCondition(orderByCommand, orderByTableFieldName);
            }
        }
    }

    public ParseOrderByCondHandler(JSONObject queryObject, Map<String, MetaModelField> modelFieldToTableField) {
        this.queryObject = queryObject;
        this.modelFieldToTableField = modelFieldToTableField;
    }
}

