/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.orm;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.qqt.pool.common.exception.BusinessException;
import com.qqt.pool.common.orm.MetaModelField;
import com.qqt.pool.common.orm.ParseHandler;
import com.qqt.pool.common.orm.ParserContext;
import com.qqt.pool.common.orm.QueryKeyWord;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ParseWhereCondHandler
implements ParseHandler {
    private JSONObject queryObject;
    private Map<String, MetaModelField> modelFieldToTableField;

    @Override
    public void apply(ParserContext parserContext) {
        String tableFieldName;
        MetaModelField metaModelField;
        String[] fieldNameAndOperation;
        Set defaultQueryFieldSet = this.queryObject.keySet().stream().filter(key -> !key.contains(".") && !QueryKeyWord.queryKeyWord.contains(key)).collect(Collectors.toSet());
        for (Iterator defaultQueryField : defaultQueryFieldSet) {
            MetaModelField metaModelField2 = this.modelFieldToTableField.get(defaultQueryField);
            this.validField(metaModelField2, (String)((Object)defaultQueryField));
            Object searchValue = this.queryObject.get((Object)defaultQueryField);
            this.queryObject.remove(defaultQueryField);
            if (metaModelField2.isLikeSearch()) {
                this.queryObject.put(defaultQueryField + ".like", searchValue);
                continue;
            }
            this.queryObject.put(defaultQueryField + ".eq", searchValue);
        }
        Set betweenKeySet = this.queryObject.keySet().stream().filter(key -> key.contains(".between")).collect(Collectors.toSet());
        for (String key2 : betweenKeySet) {
            Object value = this.queryObject.get((Object)key2);
            if (!(value instanceof List)) {
                throw new BusinessException("value must be array", String.format("%s \u7684\u503c\u5fc5\u987b\u4e3a\u6570\u7ec4", key2));
            }
            List betweenCondition = (List)value;
            if (betweenCondition.size() != 2) {
                throw new BusinessException("value must have two elements", String.format("%s \u7684\u503c\u5fc5\u987b\u4e3a\u4e24\u4e2a", key2));
            }
            fieldNameAndOperation = key2.split("\\.");
            String operation = fieldNameAndOperation[1];
            String modelFieldName = fieldNameAndOperation[0];
            metaModelField = this.modelFieldToTableField.get(modelFieldName);
            this.validField(metaModelField, modelFieldName);
            tableFieldName = metaModelField.getTableFieldName();
            parserContext.addQueryCondition(operation, tableFieldName, value);
        }
        for (String key2 : betweenKeySet) {
            this.queryObject.remove((Object)key2);
        }
        Set validQueryObj = this.queryObject.entrySet().stream().filter(entry -> {
            boolean isValidValue;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.contains(".isNull") || key.contains(".isNotNull")) {
                return true;
            }
            boolean isValidKey = key.contains(".");
            boolean bl = isValidValue = value != null && StrUtil.isNotBlank((CharSequence)value.toString());
            if (value instanceof List && CollectionUtil.isEmpty((Collection)((List)value))) {
                isValidValue = false;
            }
            return isValidKey && isValidValue;
        }).collect(Collectors.toSet());
        for (Map.Entry entry2 : validQueryObj) {
            String key3 = (String)entry2.getKey();
            fieldNameAndOperation = key3.split("\\.");
            String modelFieldName = fieldNameAndOperation[0];
            String operation = fieldNameAndOperation[1];
            metaModelField = this.modelFieldToTableField.get(modelFieldName);
            this.validField(metaModelField, modelFieldName);
            tableFieldName = metaModelField.getTableFieldName();
            String modelFieldType = metaModelField.getModelFieldType();
            Object value = entry2.getValue();
            if (Date.class.getTypeName().equals(modelFieldType)) {
                String dateStr;
                if (value instanceof Long) {
                    value = new Date((Long)value);
                }
                if (value instanceof String && StrUtil.isNotBlank((CharSequence)(dateStr = (String)value))) {
                    value = DateUtil.parse((CharSequence)dateStr, (String)"yyyy-MM-dd HH:mm:ss").toJdkDate();
                }
            }
            if ("in".equals(operation) && value instanceof String) {
                value = ((String)value).split(",");
            }
            parserContext.addQueryCondition(operation, tableFieldName, value);
        }
    }

    private void validField(MetaModelField metaModelField, String queryFieldName) {
        if (metaModelField == null) {
            throw new BusinessException("query field not exist", String.format("\u67e5\u8be2\u5b57\u6bb5[%s]\u4e0d\u5b58\u5728", queryFieldName));
        }
    }

    public ParseWhereCondHandler(JSONObject queryObject, Map<String, MetaModelField> modelFieldToTableField) {
        this.queryObject = queryObject;
        this.modelFieldToTableField = modelFieldToTableField;
    }
}

