/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.google.common.collect.Lists;
import com.qqt.pool.common.service.ExportService;
import com.qqt.pool.common.utils.EasyExcelUtils;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BaseExportServiceImpl
implements ExportService {
    private final Logger log = LoggerFactory.getLogger(BaseExportServiceImpl.class);
    @Value(value="${data.report.limitMaxSize:2000000}")
    private Integer limitMaxSize;
    @Value(value="${data.report.filePath:/mnt/upload}")
    private String filePath;

    public <T> void writeReportExcelNoPage(Class<T> clazz, List<T> dataList, String fileName) {
        String filePathAndName = this.filePath + fileName;
        try {
            File file = new File(filePathAndName);
            this.log.info("\u751f\u6210\u62a5\u8868\u6587\u4ef6 start filePath:{} size:{}", (Object)filePathAndName, (Object)dataList.size());
            int[] mergeColumeIndex = new int[]{1, 2, 3, 4};
            int mergeRowIndex = 2;
            ExcelWriter excelWriter = EasyExcelUtils.getExcelWriterNew(file, clazz);
            Lists.partition(dataList, (int)this.limitMaxSize).forEach(item -> {
                WriteSheet writeSheet = EasyExcel.writerSheet((String)fileName).build();
                excelWriter.write(dataList, writeSheet);
            });
            excelWriter.finish();
            this.log.info("\u751f\u6210\u62a5\u8868\u6587\u4ef6\u6210\u529f filePath:{}", (Object)filePathAndName);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.info("\u751f\u6210\u62a5\u8868\u6587\u4ef6\u5931\u8d25 writeReportExcelNoPage filePath:{}, ex:{}", (Object)filePathAndName, (Object)e.getMessage());
            throw new RuntimeException("\u751f\u6210\u62a5\u8868\u6587\u4ef6\u5931\u8d25!");
        }
    }

    @Override
    public void createAndUploadReportFileNoPage() {
    }

    @Override
    public void createAndUploadReportFileNoPage(List data) {
    }
}

