/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.utils;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qqt.pool.common.dto.CompanyDO;
import com.qqt.pool.common.dto.ResultDTO;
import com.qqt.pool.common.feign.AdminFeignService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class AdminEntityCacheUtils {
    public static final long EXPIRE_TIME = 21600000L;
    @Autowired
    private AdminFeignService adminFeignService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private RedisTemplate redisTemplate;
    private static TimedCache companyCache = CacheUtil.newTimedCache((long)21600000L);

    public CompanyDO getCompanyDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Object map = companyCache.get((Object)id);
        if (map == null) {
            ResultDTO<CompanyDO> companyResp = this.adminFeignService.getCompanyById(id);
            if (companyResp != null && companyResp.getData() != null && companyResp.isSuccess()) {
                CompanyDO companyDO = companyResp.getData();
                companyCache.put((Object)id, (Object)companyDO);
                return companyDO;
            }
        } else {
            return (CompanyDO)this.objectMapper.convertValue(map, CompanyDO.class);
        }
        return null;
    }

    public String getUserName(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Object object = this.redisTemplate.opsForHash().get((Object)"jhi_user", (Object)id);
        if (null == object) {
            ResultDTO<String> result = this.adminFeignService.getUserNameById(id);
            if (result != null && result.getData() != null && result.isSuccess()) {
                return result.getData();
            }
        } else {
            return object.toString();
        }
        return null;
    }
}

