/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qqt.pool.common.dto.ModifiedProperty;
import com.qqt.pool.common.dto.PropertyModel;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CompareObjectPropertyUtil {
    private static final Logger log = LoggerFactory.getLogger(CompareObjectPropertyUtil.class);
    private static final String[] IGNORE_ANNOTATION = new String[]{"JsonIgnoreProperties", "JsonIgnore", "OneToMany", "ManyToMany", "ManyToOne", "OneToOne"};

    public static <T> String getDifferentProperty(T oldObj, T newObj, String ... ignoreProperties) {
        Object value;
        String propertyName;
        if (!oldObj.getClass().equals(newObj.getClass())) {
            return null;
        }
        if ((ignoreProperties == null || ignoreProperties.length > 0) && oldObj.equals(newObj)) {
            return null;
        }
        List<PropertyModel> oldObjectPropertyValue = CompareObjectPropertyUtil.getObjectPropertyValue(oldObj, ignoreProperties);
        if (CollectionUtils.isEmpty(oldObjectPropertyValue)) {
            return null;
        }
        ArrayList<ModifiedProperty> modifiedProperties = new ArrayList<ModifiedProperty>(oldObjectPropertyValue.size());
        List<PropertyModel> newObjectPropertyValue = CompareObjectPropertyUtil.getObjectPropertyValue(newObj, ignoreProperties);
        HashMap<String, Object> objectMap = new HashMap<String, Object>(newObjectPropertyValue.size());
        for (PropertyModel PropertyModel2 : newObjectPropertyValue) {
            propertyName = PropertyModel2.getPropertyName();
            value = PropertyModel2.getValue();
            objectMap.put(propertyName, value);
        }
        for (PropertyModel PropertyModel2 : oldObjectPropertyValue) {
            propertyName = PropertyModel2.getPropertyName();
            value = PropertyModel2.getValue();
            if (!objectMap.containsKey(propertyName)) continue;
            Object newValue = objectMap.get(propertyName);
            ModifiedProperty ModifiedProperty2 = new ModifiedProperty();
            if (value != null && newValue != null) {
                if (value.equals(newValue)) continue;
                ModifiedProperty2.setPropertyName(propertyName);
                ModifiedProperty2.setOriginalValue(value);
                ModifiedProperty2.setValue(newValue);
                modifiedProperties.add(ModifiedProperty2);
                continue;
            }
            if ((newValue != null || value == null || StringUtils.isEmpty((Object)value.toString())) && (value != null || newValue == null || StringUtils.isEmpty((Object)newValue.toString()))) continue;
            ModifiedProperty2.setPropertyName(propertyName);
            ModifiedProperty2.setOriginalValue(value);
            ModifiedProperty2.setValue(newValue);
            modifiedProperties.add(ModifiedProperty2);
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(modifiedProperties);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static <T> List<PropertyModel> getObjectPropertyValue(T obj, String ... ignoreProperties) {
        if (obj != null) {
            Class<?> objClass = obj.getClass();
            PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(objClass);
            ArrayList<PropertyModel> modelInfos = new ArrayList<PropertyModel>(propertyDescriptors.length);
            Field[] fields = objClass.getDeclaredFields();
            List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
            for (Field field : fields) {
                if (field.getName().equals("serialVersionUID")) continue;
                Annotation[] annotations = field.getDeclaredAnnotations();
                boolean flag = false;
                for (Annotation annotation : annotations) {
                    if (!Arrays.asList(IGNORE_ANNOTATION).contains(annotation.annotationType().getSimpleName())) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                field.setAccessible(true);
                String fieldName = field.getName();
                if (ignoreList != null && ignoreList.contains(fieldName)) continue;
                PropertyModel PropertyModel2 = new PropertyModel();
                PropertyModel2.setPropertyName(fieldName);
                PropertyModel2.setReturnType(field.getType());
                Object fieldValue = CompareObjectPropertyUtil.getFieldValueByName(field, obj);
                PropertyModel2.setValue(fieldValue == null ? "" : fieldValue);
                modelInfos.add(PropertyModel2);
            }
            return modelInfos;
        }
        return Collections.emptyList();
    }

    private static Object getFieldValueByName(Field field, Object o) {
        String fieldName = field.getName();
        String firstLetter = fieldName.substring(0, 1).toUpperCase();
        String prefix = "get";
        Class<?> clazz = field.getType();
        if (clazz.getSimpleName().equalsIgnoreCase(Boolean.class.getSimpleName())) {
            prefix = "is";
        }
        String getter = prefix + firstLetter + fieldName.substring(1);
        try {
            Method method = o.getClass().getMethod(getter, new Class[0]);
            return method.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

