/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.utils;

import com.qqt.pool.common.config.HttpClientConfig;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class HttpClientUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static volatile OkHttpClient client;

    public static Headers doLoginRequest(HttpClientConfig config, Map<String, String> params) {
        try {
            OkHttpClient client = HttpClientUtils.getInstance(config);
            FormBody.Builder builder = new FormBody.Builder();
            for (Map.Entry<String, String> param2 : params.entrySet()) {
                builder.add(param2.getKey(), param2.getValue());
            }
            FormBody formBody = builder.build();
            Request request = new Request.Builder().url(config.getUrl()).post((RequestBody)formBody).build();
            Response response = client.newCall(request).execute();
            if (response.isSuccessful() && response.body() != null) {
                return response.headers();
            }
            if (response.body() != null) {
                return null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String doFormRequest(HttpClientConfig config, Map<String, String> params, String cookie) {
        try {
            OkHttpClient client = HttpClientUtils.getInstance(config);
            FormBody.Builder builder = new FormBody.Builder();
            for (Map.Entry<String, String> param2 : params.entrySet()) {
                builder.add(param2.getKey(), param2.getValue());
            }
            FormBody formBody = builder.build();
            Request request = new Request.Builder().url(config.getUrl()).header("Cookie", cookie).post((RequestBody)formBody).build();
            Response response = client.newCall(request).execute();
            if (response.isSuccessful() && response.body() != null) {
                return response.body().string();
            }
            if (response.body() != null) {
                return response.body().string();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String doRequest(HttpClientConfig config, HttpMethod method, Map<String, String> headers, String body) {
        try {
            Request request;
            Response response;
            OkHttpClient client = HttpClientUtils.getInstance(config);
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)(StringUtils.isEmpty((Object)body) ? "" : body));
            Request.Builder builder = new Request.Builder();
            if (!CollectionUtils.isEmpty(headers)) {
                logger.info("headers : " + headers);
                builder.headers(Headers.of(headers));
            }
            if ((response = client.newCall(request = builder.method(method.name(), requestBody).url(config.getUrl()).build()).execute()).isSuccessful() && response.body() != null) {
                return response.body().string();
            }
            if (response.body() != null) {
                return response.body().string();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static OkHttpClient getInstance(HttpClientConfig config) {
        if (client == null) {
            Class<OkHttpClient> clazz = OkHttpClient.class;
            // MONITORENTER : okhttp3.OkHttpClient.class
            if (client == null) {
                client = HttpClientUtils.createHttpClient(config);
            }
            // MONITOREXIT : clazz
        }
        client.newBuilder().addInterceptor(chain -> {
            Request request = chain.request();
            if (StringUtils.hasText((String)config.getUsername()) && StringUtils.hasText((String)config.getPassword())) {
                Request authReq = chain.request().newBuilder().addHeader("Authorization", Credentials.basic((String)config.getUsername(), (String)config.getPassword())).build();
                return chain.proceed(authReq);
            }
            if (StringUtils.hasText((String)config.getOauthToken())) {
                Request authReq = chain.request().newBuilder().addHeader("Authorization", "Bearer " + config.getOauthToken()).build();
                return chain.proceed(authReq);
            }
            return chain.proceed(request);
        });
        return client;
    }

    private static OkHttpClient createHttpClient(HttpClientConfig config) {
        try {
            OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
            httpClientBuilder.followRedirects(true);
            httpClientBuilder.followSslRedirects(true);
            if (config.getConnectionTimeout() > 0) {
                httpClientBuilder.connectTimeout((long)config.getConnectionTimeout(), TimeUnit.MILLISECONDS);
            }
            if (config.getRequestTimeout() > 0) {
                httpClientBuilder.readTimeout((long)config.getRequestTimeout(), TimeUnit.MILLISECONDS);
            }
            if (config.getWebSocketPingInterval() > 0) {
                httpClientBuilder.pingInterval((long)config.getWebSocketPingInterval(), TimeUnit.MILLISECONDS);
            }
            if (config.getMaxConcurrentRequestsPerHost() > 0) {
                Dispatcher dispatcher = new Dispatcher();
                dispatcher.setMaxRequestsPerHost(config.getMaxConcurrentRequestsPerHost());
                httpClientBuilder.dispatcher(dispatcher);
            }
            if (config.getMaxConnection() > 0) {
                ConnectionPool connectionPool = new ConnectionPool(config.getMaxConnection(), 60L, TimeUnit.SECONDS);
                httpClientBuilder.connectionPool(connectionPool);
            }
            if (config.getUrl().toLowerCase().startsWith("http://") || config.getUrl().startsWith("https://")) {
                try {
                    URL proxyUrl = HttpClientUtils.getProxyUrl(config);
                    if (proxyUrl != null) {
                        httpClientBuilder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUrl.getHost(), proxyUrl.getPort())));
                        if (config.getProxyUsername() != null) {
                            httpClientBuilder.proxyAuthenticator((route, response) -> {
                                String credential = Credentials.basic((String)config.getProxyUsername(), (String)config.getProxyPassword());
                                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                            });
                        }
                    }
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Invalid proxy server configuration", e);
                }
            }
            if (config.getUserAgent() != null && !config.getUserAgent().isEmpty()) {
                httpClientBuilder.addNetworkInterceptor(chain -> {
                    Request agent = chain.request().newBuilder().header("User-Agent", config.getUserAgent()).build();
                    return chain.proceed(agent);
                });
            }
            if (config.getTlsVersions() != null && config.getTlsVersions().length > 0) {
                ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(config.getTlsVersions()).build();
                httpClientBuilder.connectionSpecs(Arrays.asList(spec, ConnectionSpec.CLEARTEXT));
            }
            return httpClientBuilder.build();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u521b\u5efaOKHTTPClient\u9519\u8bef", e);
        }
    }

    private static URL getProxyUrl(HttpClientConfig config) throws MalformedURLException {
        URL master = new URL(config.getUrl());
        String host = master.getHost();
        if (config.getNoProxy() != null) {
            for (String noProxy : config.getNoProxy()) {
                if (!host.endsWith(noProxy)) continue;
                return null;
            }
        }
        String proxy = config.getHttpsProxy();
        String http = "http";
        if (http.equals(master.getProtocol())) {
            proxy = config.getHttpProxy();
        }
        if (proxy != null) {
            return new URL(proxy);
        }
        return null;
    }
}

