/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.qqt.pool.common.config.HttpClientConfig;
import com.qqt.pool.common.domain.xxljob.XxlJobActuatorManagerInfo;
import com.qqt.pool.common.domain.xxljob.XxlJobGroup;
import com.qqt.pool.common.domain.xxljob.XxlJobInfo;
import com.qqt.pool.common.domain.xxljob.XxlJobResponseInfo;
import com.qqt.pool.common.domain.xxljob.XxlJobTaskManagerInfo;
import com.qqt.pool.common.utils.HttpClientUtils;
import java.util.HashMap;
import java.util.List;
import okhttp3.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class XxlJobApiUtils {
    private static final Logger logger = LoggerFactory.getLogger(XxlJobApiUtils.class);
    private String xxlJobLoginAddress;
    private String xxlJobLoginUserName;
    private String xxlJobLoginPassword;

    public XxlJobApiUtils() {
    }

    public XxlJobApiUtils(String xxlJobLoginAddress, String xxlJobLoginUserName, String xxlJobLoginPassword) {
        this.xxlJobLoginAddress = xxlJobLoginAddress;
        this.xxlJobLoginUserName = xxlJobLoginUserName;
        this.xxlJobLoginPassword = xxlJobLoginPassword;
    }

    public void startTask(Integer taskId) {
        HttpClientConfig clientConfig = new HttpClientConfig();
        String cookie = this.loginTaskCenter(clientConfig);
        HashMap<String, String> form = new HashMap<String, String>();
        form.put("id", "" + taskId);
        clientConfig.setUrl(this.xxlJobLoginAddress + "/jobinfo/start");
        String result = HttpClientUtils.doFormRequest(clientConfig, form, cookie);
        XxlJobResponseInfo info = (XxlJobResponseInfo)JSONUtil.toBean((JSONObject)JSONUtil.parseObj((String)result), XxlJobResponseInfo.class);
        if (ObjectUtil.isNull((Object)info) || info.getCode().intValue() != HttpStatus.OK.value()) {
            logger.error(info.getMsg(), (Throwable)new RuntimeException());
        }
    }

    public void deleteTask(Integer id) {
        HttpClientConfig clientConfig = new HttpClientConfig();
        String cookie = this.loginTaskCenter(clientConfig);
        HashMap<String, String> form = new HashMap<String, String>();
        form.put("id", id + "");
        clientConfig.setUrl(this.xxlJobLoginAddress + "/jobinfo/remove");
        String result = HttpClientUtils.doFormRequest(clientConfig, form, cookie);
        XxlJobResponseInfo info = (XxlJobResponseInfo)JSONUtil.toBean((JSONObject)JSONUtil.parseObj((String)result), XxlJobResponseInfo.class);
        if (ObjectUtil.isNull((Object)info) || info.getCode().intValue() != HttpStatus.OK.value()) {
            logger.error(info.getMsg(), (Throwable)new RuntimeException());
        }
    }

    public void editTask(XxlJobInfo xxlJobInfo) {
        HttpClientConfig clientConfig = new HttpClientConfig();
        String cookie = this.loginTaskCenter(clientConfig);
        HashMap<String, String> form = new HashMap<String, String>();
        form.put("id", xxlJobInfo.getId() + "");
        form.put("jobGroup", xxlJobInfo.getJobGroup() + "");
        form.put("jobDesc", xxlJobInfo.getJobDesc());
        form.put("executorRouteStrategy", "ROUND");
        form.put("jobCron", xxlJobInfo.getJobCron());
        form.put("glueType", "BEAN");
        form.put("executorHandler", xxlJobInfo.getExecutorHandler());
        form.put("executorBlockStrategy", "SERIAL_EXECUTION");
        form.put("author", "mye");
        clientConfig.setUrl(this.xxlJobLoginAddress + "/jobinfo/update");
        String result = HttpClientUtils.doFormRequest(clientConfig, form, cookie);
        XxlJobResponseInfo info = (XxlJobResponseInfo)JSONUtil.toBean((JSONObject)JSONUtil.parseObj((String)result), XxlJobResponseInfo.class);
        if (ObjectUtil.isNull((Object)info) || info.getCode().intValue() != HttpStatus.OK.value()) {
            logger.error(info.getMsg(), (Throwable)new RuntimeException());
        }
    }

    public XxlJobTaskManagerInfo selectTask(XxlJobInfo xxlJobInfo) {
        HttpClientConfig clientConfig = new HttpClientConfig();
        String cookie = this.loginTaskCenter(clientConfig);
        HashMap<String, String> form = new HashMap<String, String>();
        form.put("jobGroup", xxlJobInfo.getJobGroup() + "");
        form.put("jobDesc", xxlJobInfo.getJobDesc());
        form.put("executorHandler", xxlJobInfo.getExecutorHandler());
        form.put("author", xxlJobInfo.getAuthor());
        form.put("triggerStatus", xxlJobInfo.getTriggerStatus() + "");
        clientConfig.setUrl(this.xxlJobLoginAddress + "/jobinfo/pageList");
        String result = HttpClientUtils.doFormRequest(clientConfig, form, cookie);
        XxlJobTaskManagerInfo info = (XxlJobTaskManagerInfo)JSONUtil.toBean((JSONObject)JSONUtil.parseObj((String)result), XxlJobTaskManagerInfo.class);
        if (ObjectUtil.isNull((Object)info) || CollectionUtil.isEmpty(info.getData())) {
            logger.error("xxl-job\u4efb\u52a1\u7ba1\u7406\u4e0d\u5b58\u5728", (Throwable)new RuntimeException());
        }
        return info;
    }

    public XxlJobResponseInfo createTask(XxlJobInfo xxlJobInfo) {
        HttpClientConfig clientConfig = new HttpClientConfig();
        String cookie = this.loginTaskCenter(clientConfig);
        HashMap<String, String> form = new HashMap<String, String>();
        form.put("jobGroup", xxlJobInfo.getJobGroup() + "");
        form.put("jobDesc", xxlJobInfo.getJobDesc());
        form.put("executorRouteStrategy", xxlJobInfo.getExecutorRouteStrategy());
        form.put("scheduleConf", xxlJobInfo.getJobCron());
        form.put("glueType", "BEAN");
        form.put("executorHandler", xxlJobInfo.getExecutorHandler());
        form.put("executorParam", xxlJobInfo.getExecutorParam());
        form.put("executorBlockStrategy", xxlJobInfo.getExecutorBlockStrategy());
        form.put("author", xxlJobInfo.getAuthor());
        form.put("scheduleType", xxlJobInfo.getScheduleType());
        form.put("misfireStrategy", xxlJobInfo.getMisfireStrategy());
        form.put("triggerStatus", String.valueOf(xxlJobInfo.getTriggerStatus()));
        form.put("mallLoginUserName", xxlJobInfo.getMallLoginUserName());
        form.put("mallLoginPassword", xxlJobInfo.getMallLoginPassword());
        form.put("mallLoginLanguage", xxlJobInfo.getMallLoginLanguage());
        form.put("mallLoginCurrency", xxlJobInfo.getMallLoginCurrency());
        form.put("mallLoginElsAccount", xxlJobInfo.getMallLoginElsAccount());
        form.put("mallLoginStore", xxlJobInfo.getMallLoginStore());
        clientConfig.setUrl(this.xxlJobLoginAddress + "/jobinfo/add");
        String result = HttpClientUtils.doFormRequest(clientConfig, form, cookie);
        XxlJobResponseInfo info = (XxlJobResponseInfo)JSONUtil.toBean((JSONObject)JSONUtil.parseObj((String)result), XxlJobResponseInfo.class);
        if (ObjectUtil.isNull((Object)info) || info.getCode().intValue() != HttpStatus.OK.value()) {
            logger.error(info.getMsg(), (Throwable)new RuntimeException());
        }
        return info;
    }

    public void deleteActuator(XxlJobGroup xxlJobGroup) {
        HttpClientConfig clientConfig = new HttpClientConfig();
        String cookie = this.loginTaskCenter(clientConfig);
        HashMap<String, String> form = new HashMap<String, String>();
        form.put("id", xxlJobGroup.getId() + "");
        clientConfig.setUrl(this.xxlJobLoginAddress + "/jobgroup/remove");
        String result = HttpClientUtils.doFormRequest(clientConfig, form, cookie);
        XxlJobResponseInfo info = (XxlJobResponseInfo)JSONUtil.toBean((JSONObject)JSONUtil.parseObj((String)result), XxlJobResponseInfo.class);
        if (ObjectUtil.isNull((Object)info) || info.getCode().intValue() != HttpStatus.OK.value()) {
            logger.error(info.getMsg(), (Throwable)new RuntimeException());
        }
    }

    public void editActuator(XxlJobGroup xxlJobGroup) {
        HttpClientConfig clientConfig = new HttpClientConfig();
        String cookie = this.loginTaskCenter(clientConfig);
        HashMap<String, String> form = new HashMap<String, String>();
        form.put("appname", xxlJobGroup.getAppname());
        form.put("title", xxlJobGroup.getTitle());
        form.put("addressType", xxlJobGroup.getAddressType() + "");
        form.put("id", xxlJobGroup.getId() + "");
        clientConfig.setUrl(this.xxlJobLoginAddress + "/jobgroup/update");
        String result = HttpClientUtils.doFormRequest(clientConfig, form, cookie);
        XxlJobResponseInfo info = (XxlJobResponseInfo)JSONUtil.toBean((JSONObject)JSONUtil.parseObj((String)result), XxlJobResponseInfo.class);
        if (ObjectUtil.isNull((Object)info) || info.getCode().intValue() != HttpStatus.OK.value()) {
            logger.error(info.getMsg(), (Throwable)new RuntimeException());
        }
    }

    public List<XxlJobGroup> selectActuator(XxlJobGroup xxlJobGroup) {
        HttpClientConfig clientConfig = new HttpClientConfig();
        String cookie = this.loginTaskCenter(clientConfig);
        HashMap<String, String> form = new HashMap<String, String>();
        form.put("appname", xxlJobGroup.getAppname());
        form.put("title", xxlJobGroup.getTitle());
        clientConfig.setUrl(this.xxlJobLoginAddress + "/jobgroup/pageList");
        String result = HttpClientUtils.doFormRequest(clientConfig, form, cookie);
        XxlJobActuatorManagerInfo info = (XxlJobActuatorManagerInfo)JSONUtil.toBean((JSONObject)JSONUtil.parseObj((String)result), XxlJobActuatorManagerInfo.class);
        if (CollectionUtil.isEmpty(info.getData())) {
            throw new RuntimeException("\u8be5\u6267\u884c\u5668\u7ba1\u7406\u5668\u4e0d\u5b58\u5728:" + xxlJobGroup.getAppname());
        }
        return info.getData();
    }

    public XxlJobResponseInfo createActuator(XxlJobGroup xxlJobGroup) {
        HttpClientConfig clientConfig = new HttpClientConfig();
        String cookie = this.loginTaskCenter(clientConfig);
        HashMap<String, String> form = new HashMap<String, String>();
        form.put("appname", xxlJobGroup.getAppname());
        form.put("title", xxlJobGroup.getTitle());
        form.put("addressType", xxlJobGroup.getAddressType() + "");
        clientConfig.setUrl(this.xxlJobLoginAddress + "/jobgroup/save");
        String result = HttpClientUtils.doFormRequest(clientConfig, form, cookie);
        XxlJobResponseInfo info = (XxlJobResponseInfo)JSONUtil.toBean((JSONObject)JSONUtil.parseObj((String)result), XxlJobResponseInfo.class);
        if (ObjectUtil.isNull((Object)info) || info.getCode().intValue() != HttpStatus.OK.value()) {
            logger.error(info.getMsg(), (Throwable)new RuntimeException());
        }
        return info;
    }

    public String loginTaskCenter(HttpClientConfig clientConfig) {
        HashMap<String, String> loginForm = new HashMap<String, String>();
        clientConfig.setUrl(this.xxlJobLoginAddress + "/login");
        clientConfig.setUsername(this.xxlJobLoginUserName);
        clientConfig.setPassword(this.xxlJobLoginPassword);
        loginForm.put("userName", this.xxlJobLoginUserName);
        loginForm.put("password", this.xxlJobLoginPassword);
        Headers headers = HttpClientUtils.doLoginRequest(clientConfig, loginForm);
        assert (headers != null);
        return headers.get("Set-Cookie");
    }
}

