/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.config;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.plumelog.core.MessageAppenderFactory;
import com.plumelog.core.client.AbstractClient;
import com.plumelog.core.constant.LogMessageConstant;
import com.plumelog.core.dto.BaseLogMessage;
import com.plumelog.core.dto.RunLogMessage;
import com.plumelog.core.redis.RedisClient;
import com.plumelog.core.redis.RedisSentinelClient;
import com.plumelog.core.util.GfJsonUtil;
import com.plumelog.core.util.StringUtils;
import com.plumelog.core.util.ThreadPoolUtil;
import com.plumelog.logback.util.LogMessageUtil;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.context.annotation.Primary;

@Primary
public class RedisAppender
extends AppenderBase<ILoggingEvent> {
    private static final ThreadPoolExecutor threadPoolExecutor = ThreadPoolUtil.getPool();
    private AbstractClient redisClient;
    private String appName;
    private String env = "default";
    private String redisHost;
    private String redisPort;
    private String redisAuth;
    private String model = "standalone";
    private String masterName;
    private int redisDb = 0;
    private String runModel;
    private String expand;
    private int maxCount = 100;
    private int logQueueSize = 10000;
    private int threadPoolSize = 1;
    private boolean compressor = false;
    private boolean enabled = false;

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getRedisHost() {
        return this.redisHost;
    }

    public void setRedisHost(String redisHost) {
        this.redisHost = redisHost;
    }

    public String getRedisPort() {
        return this.redisPort;
    }

    public void setRedisPort(String redisPort) {
        this.redisPort = redisPort;
    }

    public void setRedisAuth(String redisAuth) {
        this.redisAuth = redisAuth;
    }

    public int getRedisDb() {
        return this.redisDb;
    }

    public void setRedisDb(int redisDb) {
        this.redisDb = redisDb;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public String getRunModel() {
        return this.runModel;
    }

    public void setRunModel(String runModel) {
        this.runModel = runModel;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public int getLogQueueSize() {
        return this.logQueueSize;
    }

    public void setLogQueueSize(int logQueueSize) {
        this.logQueueSize = logQueueSize;
    }

    public boolean isCompressor() {
        return this.compressor;
    }

    public void setCompressor(boolean compressor) {
        this.compressor = compressor;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected void append(ILoggingEvent event) {
        if (event != null) {
            this.send(event);
        }
    }

    protected void send(ILoggingEvent event) {
        BaseLogMessage logMessage = LogMessageUtil.getLogMessage((String)this.appName, (String)this.env, (ILoggingEvent)event, (String)this.runModel);
        if (logMessage instanceof RunLogMessage) {
            String message = LogMessageUtil.getLogMessage((BaseLogMessage)logMessage, (ILoggingEvent)event);
            MessageAppenderFactory.pushRundataQueue((String)message);
        } else {
            MessageAppenderFactory.pushTracedataQueue((String)GfJsonUtil.toJSONString((Object)logMessage));
        }
    }

    public void start() {
        int a;
        System.err.println(this.getAppName() + " plumlog enabled======================>" + this.getEnabled());
        if (!this.getEnabled()) {
            return;
        }
        super.start();
        if (this.runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(this.runModel);
        }
        if (this.expand != null && LogMessageConstant.EXPANDS.contains(this.expand)) {
            LogMessageConstant.EXPAND = this.expand;
        }
        if (this.redisClient == null) {
            if (StringUtils.isNotEmpty((String)this.masterName)) {
                this.redisClient = RedisSentinelClient.getInstance((String)this.redisHost, (String)this.masterName, (String)this.redisAuth, (int)this.redisDb);
            } else {
                int port = 6379;
                String ip = "127.0.0.1";
                if (this.redisPort == null) {
                    if (this.redisHost.contains(":")) {
                        String[] hs = this.redisHost.split(":");
                        if (hs.length == 2) {
                            ip = hs[0];
                            port = Integer.parseInt(hs[1]);
                        }
                    } else {
                        ip = this.redisHost;
                    }
                } else {
                    ip = this.redisHost;
                    port = Integer.parseInt(this.redisPort);
                }
                this.redisClient = RedisClient.getInstance((String)ip, (int)port, (String)this.redisAuth, (int)this.redisDb);
            }
        }
        MessageAppenderFactory.initQueue((int)this.logQueueSize);
        for (a = 0; a < this.threadPoolSize; ++a) {
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startRunLog((AbstractClient)this.redisClient, (int)this.maxCount, (String)(this.compressor ? "plume_log_list_compress" : "plume_log_list"), (boolean)this.compressor));
        }
        for (a = 0; a < this.threadPoolSize; ++a) {
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startTraceLog((AbstractClient)this.redisClient, (int)this.maxCount, (String)(this.compressor ? "plume_trace_list_compress" : "plume_trace_list"), (boolean)this.compressor));
        }
    }
}

