/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.facade.impl;

import com.qqt.pool.common.dto.ResultDTO;
import com.qqt.pool.common.dto.message.MessageBodyDTO;
import com.qqt.pool.common.dto.message.UserTargetDTO;
import com.qqt.pool.common.facade.BaseFacade;
import com.qqt.pool.common.facade.MessageRecevierProvide;
import com.qqt.pool.common.facade.MessageSendFacade;
import com.qqt.pool.common.feign.AdminMessageFeignService;
import com.qqt.pool.common.utils.ResultUtil;
import java.util.Collection;
import java.util.Set;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class MessageSendFacadeImpl
extends BaseFacade
implements MessageSendFacade {
    private static final Logger log = LoggerFactory.getLogger(MessageSendFacadeImpl.class);
    @Autowired
    private AdminMessageFeignService adminMessageFeignService;

    @Override
    public ResultDTO sendMsg(MessageBodyDTO messageBody) {
        ResponseEntity<ResultDTO> responseEntity;
        log.debug("\u53d1\u9001\u6d88\u606f\u53c2\u6570\uff1a{}", (Object)messageBody);
        if (CollectionUtils.isEmpty(messageBody.getUserTargets()) || this.userTargetAllIsNull(messageBody.getUserTargets())) {
            ResultDTO<Set<UserTargetDTO>> resultDTO = this.getReceivers(messageBody);
            if (!resultDTO.isSuccess()) {
                return resultDTO;
            }
            messageBody.setUserTargets(resultDTO.getData());
        }
        if ((responseEntity = this.adminMessageFeignService.sendMsg(messageBody)) == null || responseEntity.getBody() == null) {
            log.warn("sendMsg result is null,params:{}", (Object)messageBody);
            return ResultUtil.fail("sendMsg result is null");
        }
        return (ResultDTO)responseEntity.getBody();
    }

    private boolean userTargetAllIsNull(Set<UserTargetDTO> set) {
        for (UserTargetDTO targetDTO : set) {
            if (targetDTO.getTargetId() == null) continue;
            return false;
        }
        return true;
    }

    private ResultDTO<Set<UserTargetDTO>> getReceivers(MessageBodyDTO messageBody) {
        if (messageBody == null) {
            log.warn("getRecevierList sendMsg params is null");
            return ResultUtil.fail("sendMsg params is null");
        }
        if (StringUtils.isEmpty((Object)messageBody.getRecevierConfigCode()) && messageBody.getCustomizeRecevierProvideBean() == null && messageBody.getUserTargetCompanyId() == null) {
            log.warn("getRecevierList sendMsg configCode and provideBean and UserTargetCompanyId is null");
            return ResultUtil.fail("configCode and provideBean and UserTargetCompanyId is null");
        }
        if (messageBody.getCustomizeRecevierProvideBean() != null) {
            MessageRecevierProvide provideBean = messageBody.getCustomizeRecevierProvideBean();
            ResultDTO<Set<UserTargetDTO>> result = provideBean.getRecevierList(messageBody.getBillRelations());
            if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)result.getData())) {
                return result;
            }
            if (!StringUtil.isEmpty((CharSequence)messageBody.getRecevierConfigCode()) || messageBody.getUserTargetCompanyId() != null) {
                return this.readUserTargetsByConfig(messageBody);
            }
            log.warn("getRecevierList error:{},params:{}", (Object)result.getMsg(), (Object)messageBody);
            return result;
        }
        return this.readUserTargetsByConfig(messageBody);
    }

    private ResultDTO<Set<UserTargetDTO>> readUserTargetsByConfig(MessageBodyDTO messageBody) {
        ResponseEntity<ResultDTO<Set<UserTargetDTO>>> targets = this.adminMessageFeignService.getUserTargetsByConfig(messageBody);
        ResultDTO resultDTO = (ResultDTO)targets.getBody();
        if (targets == null || resultDTO == null) {
            log.warn("readUserTargetsByConfig recevierConfig query result is null");
            return ResultUtil.fail("recevierConfig query result is null");
        }
        ResultDTO body = (ResultDTO)targets.getBody();
        if (!body.isSuccess()) {
            log.warn("readUserTargetsByConfig error:{},params:{}", (Object)body.getMsg(), (Object)messageBody);
            return body;
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)body.getData()))) {
            log.warn("readUserTargetsByConfig error:{},params:{},recevierConfig query data is null", (Object)body.getMsg(), (Object)messageBody);
            return ResultUtil.fail("recevierConfig query data is null");
        }
        return body;
    }
}

