/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.log;

import cn.hutool.core.util.StrUtil;
import com.plumelog.core.TraceId;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TraceIdFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(TraceIdFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        long startTime = System.currentTimeMillis();
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String traceId = httpServletRequest.getHeader("Feign-Trace-Id");
        if (StrUtil.isNotBlank((CharSequence)traceId)) {
            TraceId.logTraceID.set((Object)traceId);
        } else {
            TraceId.set();
        }
        try {
            MDC.put((String)"traceId", (String)((String)TraceId.logTraceID.get()));
            httpServletResponse.addHeader("X-Trace-Id", (String)TraceId.logTraceID.get());
            String source = httpServletRequest.getRemoteAddr();
            String requestUri = httpServletRequest.getRequestURI();
            log.info("\u63a5\u53e3\u8bf7\u6c42\u5f00\u59cb | \u6765\u6e90\u5730\u5740:{} | \u76ee\u6807\u5730\u5740:{}", (Object)source, (Object)requestUri);
            filterChain.doFilter(servletRequest, servletResponse);
            log.info("\u63a5\u53e3\u8bf7\u6c42\u7ed3\u675f | \u76ee\u6807\u5730\u5740:{} | \u8017\u65f6: {}ms", (Object)requestUri, (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw e;
        }
        finally {
            MDC.clear();
            TraceId.logTraceID.remove();
        }
    }

    public void destroy() {
    }
}

