/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.orm;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.qqt.pool.common.orm.MetaModelField;
import com.qqt.pool.common.orm.MetaModelUtils;
import com.qqt.pool.common.orm.ParseHandler;
import com.qqt.pool.common.orm.ParseOrderByCondHandler;
import com.qqt.pool.common.orm.ParsePageHandler;
import com.qqt.pool.common.orm.ParseSearchCondHandler;
import com.qqt.pool.common.orm.ParseWhereCondHandler;
import com.qqt.pool.common.orm.ParserContext;
import com.qqt.pool.common.orm.WhereCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.joor.Reflect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DslParser<T> {
    private static final Logger log = LoggerFactory.getLogger(DslParser.class);
    private int current = 1;
    private int size = 10;
    private Long tenantId;
    private JSONObject queryObject;
    private QueryWrapper<T> queryWrapper = new QueryWrapper();

    public DslParser() {
        this.queryObject = new JSONObject();
    }

    public DslParser(JSONObject queryObject) {
        this.queryObject = queryObject;
    }

    public DslParser(JSONObject queryObject, Long tenantId) {
        this.queryObject = queryObject;
        this.tenantId = tenantId;
    }

    public DslParser(Map<String, String[]> params) {
        JSONObject queryObject = new JSONObject();
        params.forEach((key, value) -> {
            if (value != null) {
                if (((String[])value).length == 1) {
                    queryObject.put(key, (Object)value[0]);
                } else {
                    queryObject.put(key, Arrays.asList(value));
                }
            }
        });
        this.queryObject = queryObject;
    }

    public QueryWrapper<T> parseToWrapper(Class<T> clazz) {
        if (Objects.isNull(this.queryObject)) {
            return this.queryWrapper;
        }
        Map<String, MetaModelField> modelFieldToTableField = MetaModelUtils.generateMetaModelField(clazz);
        ArrayList parseHandlerList = Lists.newArrayList();
        parseHandlerList.add(new ParseWhereCondHandler(this.queryObject, modelFieldToTableField));
        parseHandlerList.add(new ParseOrderByCondHandler(this.queryObject, modelFieldToTableField));
        parseHandlerList.add(new ParsePageHandler(this.queryObject));
        parseHandlerList.add(new ParseSearchCondHandler(this.queryObject, modelFieldToTableField, this.tenantId));
        ParserContext parserContext = new ParserContext();
        for (ParseHandler parseHandler : parseHandlerList) {
            parseHandler.apply(parserContext);
        }
        log.info("EVENT=\u89e3\u6790\u8bf7\u6c42\u53c2\u6570|RESULT={}", (Object)JSONObject.toJSONString((Object)parserContext));
        List<WhereCondition> whereCondList = parserContext.getWhereConditionList();
        this.executeWhereCondOpr(whereCondList);
        Map<String, String> orderByMap = parserContext.getOrderByMap();
        this.executeOrderByOpr(orderByMap);
        List<MetaModelField> keywordFieldList = parserContext.getKeywordFieldList();
        this.executeKeyWordSearch(keywordFieldList, parserContext.getSearchKeyword());
        this.current = parserContext.getCurrent();
        this.size = parserContext.getSize();
        return this.queryWrapper;
    }

    private void executeWhereCondOpr(List<WhereCondition> whereCondList) {
        if (CollectionUtil.isEmpty(whereCondList)) {
            return;
        }
        whereCondList.forEach(cond -> {
            String operation = cond.getOperation();
            String tableFileName = cond.getTableFieldName();
            Object value = cond.getValue();
            String between = "between";
            String isNull = "isNull";
            String isNotNull = "isNotNull";
            if (between.equalsIgnoreCase(operation)) {
                List valueList = (List)value;
                Date startTime = new Date((Long)valueList.get(0));
                Date endTime = new Date((Long)valueList.get(1));
                Reflect.on(this.queryWrapper).call(operation, new Object[]{tableFileName, startTime, endTime});
            } else if (isNull.equalsIgnoreCase(operation) || isNotNull.equalsIgnoreCase(operation)) {
                Reflect.on(this.queryWrapper).call(operation, new Object[]{tableFileName});
            } else {
                Reflect.on(this.queryWrapper).call(operation, new Object[]{tableFileName, value});
            }
        });
    }

    private void executeOrderByOpr(Map<String, String> orderByMap) {
        if (CollectionUtil.isEmpty(orderByMap)) {
            return;
        }
        orderByMap.forEach((orderByCmd, tableFileName) -> Reflect.on(this.queryWrapper).call(orderByCmd, new Object[]{tableFileName}));
    }

    private void executeKeyWordSearch(List<MetaModelField> keywordFieldList, String keyword) {
        if (CollectionUtil.isEmpty(keywordFieldList)) {
            return;
        }
        String fieldNameJoinStr = keywordFieldList.stream().map(MetaModelField::getTableFieldName).map(tableFieldName -> String.format("IFNULL(%s, '') ", tableFieldName)).collect(Collectors.joining(","));
        this.queryWrapper.like((Object)("concat( " + fieldNameJoinStr + ") "), (Object)keyword);
    }

    public IPage<T> generatePage() {
        return new Page((long)this.current, (long)this.size);
    }

    public int getCurrent() {
        return this.current;
    }

    public int getSize() {
        return this.size;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public JSONObject getQueryObject() {
        return this.queryObject;
    }

    public QueryWrapper<T> getQueryWrapper() {
        return this.queryWrapper;
    }
}

