/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.orm;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ReflectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.qqt.pool.common.orm.Keyword;
import com.qqt.pool.common.orm.Like;
import com.qqt.pool.common.orm.MetaModelField;
import com.qqt.pool.common.orm.OrderByAsc;
import com.qqt.pool.common.orm.OrderByDesc;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class MetaModelUtils {
    private static Map<String, Map<String, MetaModelField>> classMetaMapCache = new WeakHashMap<String, Map<String, MetaModelField>>();

    public static <T> Map<String, MetaModelField> generateMetaModelField(Class<T> clazz) {
        Map<String, MetaModelField> classMeta = classMetaMapCache.get(clazz.getName());
        if (CollectionUtil.isNotEmpty(classMeta)) {
            return classMeta;
        }
        Field[] fields = ReflectUtil.getFields(clazz);
        HashMap<String, MetaModelField> result = new HashMap<String, MetaModelField>(fields.length);
        for (Field field : fields) {
            TableField tableField = field.getAnnotation(TableField.class);
            TableId tableId = field.getAnnotation(TableId.class);
            if (tableField == null && tableId == null) continue;
            Keyword keyWord = field.getAnnotation(Keyword.class);
            Like like = field.getAnnotation(Like.class);
            OrderByAsc orderByAsc = field.getAnnotation(OrderByAsc.class);
            OrderByDesc orderByDesc = field.getAnnotation(OrderByDesc.class);
            String tableFieldName = tableField != null ? tableField.value() : tableId.value();
            MetaModelField metaModelField = new MetaModelField();
            metaModelField.setClassFieldName(field.getName());
            metaModelField.setTableFieldName(tableFieldName);
            metaModelField.setModelFieldType(field.getType().getTypeName());
            metaModelField.setKeyWorldSearch(keyWord != null);
            metaModelField.setLikeSearch(like != null);
            metaModelField.setOrderByAsc(orderByAsc != null);
            metaModelField.setOrderByDesc(orderByDesc != null);
            result.put(field.getName(), metaModelField);
        }
        classMetaMapCache.put(clazz.getName(), result);
        return result;
    }
}

