/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.orm;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qqt.pool.common.orm.MetaModelField;
import com.qqt.pool.common.orm.ParseHandler;
import com.qqt.pool.common.orm.ParserContext;
import com.qqt.pool.common.orm.context.QueryCondition;
import com.qqt.pool.common.orm.context.TableQueryConfig;
import com.qqt.pool.common.orm.context.TableQueryContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ParseSearchCondHandler
implements ParseHandler {
    private JSONObject queryObject;
    private Map<String, MetaModelField> modelFieldToTableField;
    private Long tenantId;

    @Override
    public void apply(ParserContext parserContext) {
        String searchKeyword;
        List<Object> keywordFields = Lists.newArrayList();
        String tableCode = this.queryObject.getString("tableCode");
        if (StrUtil.isNotBlank((CharSequence)tableCode)) {
            TableQueryConfig tableQueryConfig = TableQueryContext.getTenantTableQueryConfig(tableCode, this.tenantId);
            keywordFields = Optional.ofNullable(tableQueryConfig).map(this::getKeywordConditionList).map(this::getKeyWorldFieldSet).map(this::getKeywordMetaModelFieldList).orElse(null);
        }
        if (CollectionUtil.isEmpty((Collection)keywordFields)) {
            keywordFields = this.modelFieldToTableField.values().stream().filter(MetaModelField::isKeyWorldSearch).collect(Collectors.toList());
        }
        if (StrUtil.isNotBlank((CharSequence)(searchKeyword = this.queryObject.getString("searchKeyword")))) {
            parserContext.setSearchKeyword(searchKeyword);
            parserContext.setKeywordFieldList(keywordFields);
        }
    }

    private List<MetaModelField> getKeywordMetaModelFieldList(Set<String> keywordFieldSet) {
        if (CollectionUtil.isEmpty(keywordFieldSet)) {
            return null;
        }
        return this.modelFieldToTableField.values().stream().filter(metaModelField -> keywordFieldSet.contains(metaModelField.getClassFieldName())).collect(Collectors.toList());
    }

    private Set<String> getKeyWorldFieldSet(List<QueryCondition> keywordConditionList) {
        if (CollectionUtil.isEmpty(keywordConditionList)) {
            return null;
        }
        return keywordConditionList.stream().map(QueryCondition::getFieldName).collect(Collectors.toSet());
    }

    private List<QueryCondition> getKeywordConditionList(TableQueryConfig tableQueryConfig) {
        if (tableQueryConfig == null) {
            return null;
        }
        List<QueryCondition> conditionList = tableQueryConfig.getConditionList();
        List<QueryCondition> keywordConditionList = conditionList.stream().filter(queryCondition -> queryCondition.getSearchType() == 2).collect(Collectors.toList());
        return keywordConditionList;
    }

    public ParseSearchCondHandler(JSONObject queryObject, Map<String, MetaModelField> modelFieldToTableField, Long tenantId) {
        this.queryObject = queryObject;
        this.modelFieldToTableField = modelFieldToTableField;
        this.tenantId = tenantId;
    }
}

