/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.orm.context;

import cn.hutool.core.util.StrUtil;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.qqt.pool.common.orm.context.TableQueryConfig;

public class TableQueryContext {
    private static final Long PLATFORM_ID = 1L;
    private static Table<String, Long, TableQueryConfig> queryConfigTable = HashBasedTable.create();

    public static TableQueryConfig getTableQueryConfig(String tableCode, Long tenantId) {
        return (TableQueryConfig)queryConfigTable.get((Object)tableCode, (Object)tenantId);
    }

    public static TableQueryConfig getTenantTableQueryConfig(String tableCode, Long companyId) {
        if (StrUtil.isBlank((CharSequence)tableCode) || companyId == null) {
            return null;
        }
        TableQueryConfig tenantConfig = (TableQueryConfig)queryConfigTable.get((Object)tableCode, (Object)companyId);
        if (tenantConfig != null) {
            return tenantConfig;
        }
        return (TableQueryConfig)queryConfigTable.get((Object)tableCode, (Object)PLATFORM_ID);
    }

    public static void addTableQueryConfig(TableQueryConfig tableQueryConfig) {
        queryConfigTable.put((Object)tableQueryConfig.getTableCode(), (Object)tableQueryConfig.getCompanyId(), (Object)tableQueryConfig);
    }

    public static void removeTableQueryConfig(String tableCode, Long companyId) {
        queryConfigTable.remove((Object)tableCode, (Object)companyId);
    }
}

