/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.service;

import cn.hutool.json.JSONUtil;
import com.qqt.pool.common.security.SecurityUtils;
import com.qqt.pool.common.service.bo.UserSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SessionService {
    private Logger logger = LoggerFactory.getLogger(SessionService.class);
    @Autowired
    private RedisTemplate redisTemplate;

    public UserSession getSessionInfo() {
        Optional<String> jwtOpt = SecurityUtils.getCurrentUserJWT();
        UserSession userSession = new UserSession();
        Map sessionDataMap = null;
        if (jwtOpt.isPresent()) {
            String tokenKey = "JWT_TOKEN_DATA_" + jwtOpt.get().hashCode();
            this.logger.info("EVENT=GetSessionInfo | TokenKey={}", (Object)tokenKey);
            boolean hasJwtToken = this.redisTemplate.hasKey((Object)tokenKey);
            if (hasJwtToken) {
                sessionDataMap = this.redisTemplate.opsForHash().entries((Object)tokenKey);
            }
        }
        if (sessionDataMap != null) {
            if (sessionDataMap.containsKey("userId")) {
                userSession.setUserId((Long)sessionDataMap.get("userId"));
            }
            if (sessionDataMap.containsKey("userCode")) {
                userSession.setUserCode((String)sessionDataMap.get("userCode"));
            }
            if (sessionDataMap.containsKey("userName")) {
                userSession.setUserName((String)sessionDataMap.get("userName"));
            }
            if (sessionDataMap.containsKey("companyId")) {
                userSession.setCompanyId((Long)sessionDataMap.get("companyId"));
            }
            if (sessionDataMap.containsKey("companyCode")) {
                userSession.setCompanyCode((String)sessionDataMap.get("companyCode"));
            }
            if (sessionDataMap.containsKey("companyType")) {
                userSession.setCompanyType((String)sessionDataMap.get("companyType"));
            }
            if (sessionDataMap.containsKey("companyName")) {
                userSession.setCompanyName((String)sessionDataMap.get("companyName"));
            }
            if (sessionDataMap.containsKey("languageCode")) {
                userSession.setLanguageCode((String)sessionDataMap.get("languageCode"));
            }
            if (sessionDataMap.containsKey("storeId")) {
                userSession.setStoreId((Long)sessionDataMap.get("storeId"));
            }
            if (sessionDataMap.containsKey("storeCode")) {
                userSession.setStoreCode((String)sessionDataMap.get("storeCode"));
            }
            if (sessionDataMap.containsKey("siteId")) {
                userSession.setSiteId((Long)sessionDataMap.get("siteId"));
            }
            if (sessionDataMap.containsKey("siteCode")) {
                userSession.setSiteCode((String)sessionDataMap.get("siteCode"));
            }
            if (sessionDataMap.containsKey("currencyId")) {
                userSession.setCurrencyId((Long)sessionDataMap.get("currencyId"));
            }
            if (sessionDataMap.containsKey("languageId")) {
                userSession.setLanguageId((Long)sessionDataMap.get("languageId"));
            }
            if (sessionDataMap.containsKey("departmentId")) {
                userSession.setDepartmentId((Long)sessionDataMap.get("departmentId"));
            }
            if (sessionDataMap.containsKey("elsAccount")) {
                userSession.setElsAccount((String)sessionDataMap.get("elsAccount"));
            }
            if (sessionDataMap.containsKey("province")) {
                userSession.setProvince((String)sessionDataMap.get("province"));
            }
            if (sessionDataMap.containsKey("provinceId")) {
                userSession.setProvinceId((Long)sessionDataMap.get("provinceId"));
            }
            if (sessionDataMap.containsKey("provinceName")) {
                userSession.setProvinceName((String)sessionDataMap.get("provinceName"));
            }
            if (sessionDataMap.containsKey("city")) {
                userSession.setCity((String)sessionDataMap.get("city"));
            }
            if (sessionDataMap.containsKey("cityId")) {
                userSession.setCityId((Long)sessionDataMap.get("cityId"));
            }
            if (sessionDataMap.containsKey("cityName")) {
                userSession.setCityName((String)sessionDataMap.get("cityName"));
            }
            if (sessionDataMap.containsKey("district")) {
                userSession.setDistrict((String)sessionDataMap.get("district"));
            }
            if (sessionDataMap.containsKey("districtId")) {
                userSession.setDistrictId((Long)sessionDataMap.get("districtId"));
            }
            if (sessionDataMap.containsKey("districtName")) {
                userSession.setDistrictName((String)sessionDataMap.get("districtName"));
            }
            if (sessionDataMap.containsKey("streetId")) {
                userSession.setStreetId((Long)sessionDataMap.get("streetId"));
            }
            if (sessionDataMap.containsKey("streetName")) {
                userSession.setStreetName((String)sessionDataMap.get("streetName"));
            }
            if (sessionDataMap.containsKey("street")) {
                userSession.setStreet((String)sessionDataMap.get("street"));
            }
            if (sessionDataMap.containsKey("isPlatform")) {
                userSession.setPlatform((Boolean)sessionDataMap.get("isPlatform"));
            }
            if (sessionDataMap.containsKey("isPurchaser")) {
                userSession.setPurchaser((Boolean)sessionDataMap.get("isPurchaser"));
            }
            if (sessionDataMap.containsKey("subCompanyCode")) {
                userSession.setSubCompanyCode((String)sessionDataMap.get("subCompanyCode"));
            }
            if (sessionDataMap.containsKey("subCompanyId")) {
                userSession.setSubCompanyId((Long)sessionDataMap.get("subCompanyId"));
            }
            if (sessionDataMap.containsKey("subCompanyName")) {
                userSession.setSubCompanyName((String)sessionDataMap.get("subCompanyName"));
            }
            if (sessionDataMap.containsKey("subCompanyIdList")) {
                userSession.setSubCompanyIdList((List)sessionDataMap.get("subCompanyIdList"));
            }
            if (sessionDataMap.containsKey("anonymous")) {
                userSession.setAnonymous((Boolean)sessionDataMap.get("anonymous"));
            }
            if (sessionDataMap.containsKey("groupCode")) {
                userSession.setGroupCode((String)sessionDataMap.get("groupCode"));
            }
            if (sessionDataMap.containsKey("catalogId")) {
                userSession.setCatalogId((Long)sessionDataMap.get("catalogId"));
            }
        }
        return userSession;
    }

    public <T> T getInfo(String token, String key) {
        T info = null;
        if (!StringUtils.isEmpty((Object)token)) {
            Map sessionDataMap;
            token = token.replace("Bearer ", "");
            String tokenKey = "JWT_TOKEN_DATA_" + token.hashCode();
            boolean hasJwtToken = this.redisTemplate.hasKey((Object)tokenKey);
            if (hasJwtToken && (sessionDataMap = this.redisTemplate.opsForHash().entries((Object)tokenKey)) != null && sessionDataMap.containsKey(key)) {
                info = (T)sessionDataMap.get(key);
            }
        }
        return info;
    }

    public <T> T getInfo(String key) {
        Map sessionDataMap;
        String tokenKey;
        boolean hasJwtToken;
        Optional<String> jwtOpt = SecurityUtils.getCurrentUserJWT();
        T info = null;
        if (jwtOpt.isPresent() && (hasJwtToken = this.redisTemplate.hasKey((Object)(tokenKey = "JWT_TOKEN_DATA_" + jwtOpt.get().hashCode())).booleanValue()) && (sessionDataMap = this.redisTemplate.opsForHash().entries((Object)tokenKey)) != null && sessionDataMap.containsKey(key)) {
            info = (T)sessionDataMap.get(key);
        }
        return info;
    }

    private void setInfo(String key, Object value) {
        Optional<String> jwtOpt = SecurityUtils.getCurrentUserJWT();
        if (jwtOpt.isPresent()) {
            String tokenKey = "JWT_TOKEN_DATA_" + jwtOpt.get().hashCode();
            this.logger.debug("getSessionInfo ==>check tokenKey:{}", (Object)tokenKey);
            boolean hasJwtToken = this.redisTemplate.hasKey((Object)tokenKey);
            if (hasJwtToken) {
                this.logger.debug("checkExpired ==> begin get Jwt Token from redis.tokenKey:{}", (Object)tokenKey);
                Map sessionDataMap = this.redisTemplate.opsForHash().entries((Object)tokenKey);
                sessionDataMap.put(key, value);
                this.redisTemplate.opsForHash().putAll((Object)tokenKey, sessionDataMap);
            }
        }
    }

    public Long getAccountId(String thirdCode) {
        Map map = (Map)this.getInfo("poolAccounts");
        this.logger.info("poolAccounts | {} :", (Object)JSONUtil.toJsonStr((Object)map));
        return (Long)map.get(thirdCode);
    }

    public Boolean getPlatform() {
        return (Boolean)this.getInfo("isPlatform");
    }

    public Long getCurrentUserId() {
        return (Long)this.getInfo("userId");
    }

    public void setUserId(Long userId) {
    }

    public String getCurrentUserCode() {
        return (String)this.getInfo("userCode");
    }

    public void setUserCode(String userCode) {
    }

    public String getCurrentSiteCode() {
        return (String)this.getInfo("siteCode");
    }

    public void setSiteCode(String siteCode) {
    }

    public String getCurrentStoreCode() {
        return (String)this.getInfo("storeCode");
    }

    public void setStoreCode(String storeCode) {
    }

    public String getCurrentLanguageCode() {
        return (String)this.getInfo("languageCode");
    }

    public void setLanguageCode(String languageCode) {
    }

    public String getCurrentCompanyCode() {
        return (String)this.getInfo("companyCode");
    }

    public void setCompanyCode(String companyCode) {
    }

    public String getCurrentCompanyName() {
        return (String)this.getInfo("companyName");
    }

    public void setCompanyName(String companyName) {
    }

    public Long getSiteId() {
        return (Long)this.getInfo("siteId");
    }

    public void setSiteId(Long siteId) {
    }

    public Long getStoreId() {
        return (Long)this.getInfo("storeId");
    }

    public void setStoreId(Long storeId) {
    }

    public Long getCompanyId() {
        return (Long)this.getInfo("companyId");
    }

    public void setCompanyId(Long companyId) {
    }

    public Long getCurrencyId() {
        return (Long)this.getInfo("currencyId");
    }

    public void setCurrencyId(Long currencyId) {
    }

    public Long getLanguageId() {
        return (Long)this.getInfo("languageId");
    }

    public void setLanguageId(Long languageId) {
    }

    public Long getDepartmentId() {
        return (Long)this.getInfo("departmentId");
    }

    public void setDepartmentId(Long departmentId) {
    }

    public boolean isPlatform() {
        return (Boolean)this.getInfo("isPlatform");
    }

    public String getElsAccount() {
        return (String)this.getInfo("elsAccount");
    }

    public void setElsAccount(String elsAccount) {
    }

    public String getProvince() {
        return (String)this.getInfo("province");
    }

    public void setProvince(String province) {
        this.setInfo("province", province);
    }

    public String getCity() {
        return (String)this.getInfo("city");
    }

    public void setCity(String city) {
        this.setInfo("city", city);
    }

    public String getDistrict() {
        return (String)this.getInfo("district");
    }

    public void setDistrict(String district) {
        this.setInfo("district", district);
    }

    public String getProvinceName() {
        return (String)this.getInfo("provinceName");
    }

    public void setProvinceName(String provinceName) {
        this.setInfo("provinceName", provinceName);
    }

    public String getCityName() {
        return (String)this.getInfo("cityName");
    }

    public void setCityName(String cityName) {
        this.setInfo("cityName", cityName);
    }

    public String getDistrictName() {
        return (String)this.getInfo("districtName");
    }

    public void setDistrictName(String districtName) {
        this.setInfo("districtName", districtName);
    }

    public String getStreet() {
        return (String)this.getInfo("street");
    }

    public void setStreet(String street) {
        this.setInfo("street", street);
    }

    public String getStreetName() {
        return (String)this.getInfo("streetName");
    }

    public void setStreetName(String streetName) {
        this.setInfo("streetName", streetName);
    }

    public Long getProvinceId() {
        return (Long)this.getInfo("provinceId");
    }

    public void setProvinceId(Long provinceId) {
        this.setInfo("provinceId", provinceId);
    }

    public Long getCityId() {
        return (Long)this.getInfo("cityId");
    }

    public void setCityId(Long cityId) {
        this.setInfo("cityId", cityId);
    }

    public Long getDistrictId() {
        return (Long)this.getInfo("districtId");
    }

    public void setDistrictId(Long districtId) {
        this.setInfo("districtId", districtId);
    }

    public Long getStreetId() {
        return (Long)this.getInfo("streetId");
    }

    public void setPlatform(Boolean platform) {
        this.setInfo("isPlatform", platform);
    }

    public void setStreetId(Long streetId) {
        this.setInfo("streetId", streetId);
    }
}

